package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.ParagraphApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.ParagraphService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling Paragraph related API requests.
 *
 * <p>Implements the {@link ParagraphApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ParagraphController implements ParagraphApi {

    private final ParagraphService paragraphService;

    @Override
    public OutputInstitutionalPageDto addParagraph(
            final UUID institutionalPageId,
            final Integer position,
            final InputParagraphDto inputParagraphDto
    ) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/{}/paragraphs, position {}, inputParagraphDto: {}", institutionalPageId, position, inputParagraphDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.paragraphService.addParagraph(userId, institutionalPageId, position, inputParagraphDto);
    }

    @Override
    public OutputInstitutionalPageDto updateParagraph(
            final UUID institutionalPageId,
            final UUID paragraphId,
            final InputParagraphDto inputParagraphDto
    ) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/paragraphs/{}, inputParagraphDto: {}", institutionalPageId, paragraphId, inputParagraphDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.paragraphService.updateParagraph(userId, institutionalPageId, paragraphId, inputParagraphDto);
    }

    @Override
    public OutputInstitutionalPageDto removeParagraph(
            final UUID institutionalPageId,
            final UUID paragraphId
    ) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/paragraphs/{}", institutionalPageId, paragraphId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.paragraphService.removeParagraph(userId, institutionalPageId, paragraphId);
    }

}
