package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.PublicationApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;
import java.util.UUID;

/**
 * REST controller class for handling Publication InstitutionalPage related API requests.
 *
 * <p>Implements the {@link PublicationApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class PublicationController implements PublicationApi {

    private final InstitutionalPageService institutionalPageService;

    @Override
    public Page<OutputInstitutionalPageDto> findAllPublishedInstitutionalPages(
            final Set<String> associationsToLoad,
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Direction direction
    ) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/published");
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return this.institutionalPageService.findAllPublishedInstitutionalPages(associationsToLoad, pageable);
    }

    @Override
    public Page<OutputInstitutionalPageDto> searchPublishedInstitutionalPages(
            final InputSearchPublishedInstitutionalPageDto inputSearchPublishedInstitutionalPageDto,
            final Set<String> associationsToLoad,
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Direction direction
    ) {
        log.debug("POST /institutional-page/institutional-pages/published/search, inputSearchPublishedInstitutionalPageDto: {}", inputSearchPublishedInstitutionalPageDto);
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return institutionalPageService.searchPublishedInstitutionalPages(
                associationsToLoad,
                pageable,
                inputSearchPublishedInstitutionalPageDto
        );
    }

    @Override
    public OutputInstitutionalPageDto findPublishedInstitutionalPageById(final UUID institutionalPageId) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/published/{}", institutionalPageId);
        return this.institutionalPageService.findPublishedInstitutionalPageById(institutionalPageId);
    }

    @Override
    public OutputInstitutionalPageDto requestPublishInstitutionalPage(final UUID institutionalPageId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/published/{}", institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.requestPublishInstitutionalPage(userId, institutionalPageId);
    }

}
