package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_FIELD_IP_COPYRIGHT_YEAR_PATTERN;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO of copyright info for the institutional page.
 */
@Schema(name = "InputCopyrightDto", description = "Input DTO of copyright info for the institutional page")
@Data
@Builder
@AllArgsConstructor
public class InputCopyrightDto {

    @Schema(description = "Copyright text to display", example = "Example Corp. All rights reserved")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String text;

    @Schema(description = "Copyright year", example = "2025")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Min(value = 1000, message = VALIDATION_ERROR_FIELD_IP_COPYRIGHT_YEAR_PATTERN)
    @Max(value = 3000, message = VALIDATION_ERROR_FIELD_IP_COPYRIGHT_YEAR_PATTERN)
    private Integer year;
}
