package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO containing institutional page id and membership type for a specific member.
 */
@Data
@Builder
@AllArgsConstructor
@Schema(
        name = "OutputInstitutionalPageForMembersInHierarchyDto",
        description = "Output DTO containing institutional page id and membership type for a specific member"
)
public class OutputInstitutionalPageForMembersInHierarchyDto {

    @Schema(description = "The institutional page")
    private OutputInstitutionalPageDto institutionalPage;

    @Schema(description = "Indicates whether a user is wp leader for the specific institutional page", example = "true")
    private boolean wpLead;

}
