package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO of approval or rejection of an institutionalPage.
 */
@Data
@Builder
@AllArgsConstructor
@Schema(
        name = "OutputModerationDto",
        description = "Output DTO of approval or rejection of an institutionalPage"
)
public class OutputModerationDto {

    @Schema(
            description = "type of operation performed",
            allowableValues = {"Create", "Update", "Delete"},
            example = "Create"
    )
    private String operationType;

    @Schema(description = "Output DTO of an institutionalPage")
    private OutputInstitutionalPageDto institutionalPage;

}