package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;

import java.util.UUID;

public class UpdateLockedException extends WP2ResourceNotFoundException {

    public static final String EXCEPTION_MESSAGE =
            "InstitutionalPage with id '%s' locked for update by user with id '%s'";

    public UpdateLockedException(
            UUID institutionalPageId,
            UUID userId
    ) {
        super(EXCEPTION_MESSAGE.formatted(institutionalPageId, userId));
    }

}
