package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;

import java.util.UUID;

public class UserIsTheOnlyWpLeaderException extends WP2BusinessException {

    public static final String EXCEPTION_MESSAGE =
            "User with id '%s' is the only wp leader of institutional page with id '%s'";

    public UserIsTheOnlyWpLeaderException(
            UUID userId,
            UUID institutionalPageId
    ) {
        super(EXCEPTION_MESSAGE.formatted(userId, institutionalPageId));
    }
}
