package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Mapper(config = MapperConfiguration.class)
public interface MemberMapper {

    @BeanMapping(ignoreByDefault = true)
    @Mapping(target = "memberId", source = "memberId")
    @Mapping(target = "wpLead", source = "wpLead")
    @Mapping(target = "institutionalPage", source = "institutionalPage")
    MemberEntity toMemberEntity(
            UUID memberId,
            Boolean wpLead,
            InstitutionalPageEntity institutionalPage
    );

    @BeanMapping(ignoreByDefault = true)
    @Mapping(target = "memberId", source = "memberId")
    @Mapping(target = "wpLead", source = "wpLead")
    void updateMemberEntity(
            UUID memberId,
            Boolean wpLead,
            @MappingTarget MemberEntity entity
    );


    @BeanMapping(ignoreByDefault = true)
    @Mapping(target = "wpLead", source = "wpLead")
    void updateMemberEntity(
            @MappingTarget MemberEntity entity,
            Boolean wpLead
    );

    @Named("toMemberIds")
    default List<UUID> toMemberIds(List<MemberEntity> members) {
        return Optional.ofNullable(members)
                .orElse(new LinkedList<>())
                .stream()
                .map(member -> member.getMemberId())
                .toList();
    }

}
