package com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

/**
 * {@link MemberRequestRepository} repository.
 */
@Repository
public interface MemberRequestRepository extends JpaRepository<MemberRequestEntity, UUID> {

    List<MemberRequestEntity> findAllByInstitutionalPageIdIn(
            Set<UUID> institutionalPageIds
    );

    void deleteAllByInstitutionalPageId(
            UUID institutionalPageId
    );

    List<MemberRequestEntity> findAllByUserId(
            UUID userId
    );

    List<MemberRequestEntity> findAllByInstitutionalPageIdAndUserIdIn(
            UUID institutionalPageId,
            List<UUID> userIds
    );

    List<MemberRequestEntity> findAllByInstitutionalPageIdAndUserIdInAndRequestType(
            UUID institutionalPageId,
            List<UUID> userIds,
            MemberRequestType memberRequestType
    );

    Optional<MemberRequestEntity> findByInstitutionalPageIdAndUserIdAndRequestType(
            UUID institutionalPageId,
            UUID userId,
            MemberRequestType memberRequestType
    );

    @Query(
            value = """
                    select request.*
                    from member_request request
                    join institutional_page ip
                        on request.institutional_page_id = ip.id
                    where
                        request.user_id in (:userIds)
                        and coalesce(ip.ancestor_institutional_page_ids[1], ip.id) = :rootInstitutionalPageId
                    """,
            nativeQuery = true
    )
    List<MemberRequestEntity> findAllRequestsFromIpAndDescendants(
            @Param("rootInstitutionalPageId") UUID rootInstitutionalPageId,
            @Param("userIds") List<UUID> userIds
    );

}