package com.finconsgroup.itserr.marketplace.institutionalpage.dm.validation.validator;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.validation.ValidInputDto;
import io.micrometer.common.util.StringUtils;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class InputPatchIPJoinRequestDtoValidator implements ConstraintValidator<ValidInputDto, InputPatchIPJoinRequestDto> {

    @Override
    public boolean isValid(InputPatchIPJoinRequestDto value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }

        // if approved = false , then message is mandatory
        if (Boolean.FALSE.equals(value.getApproved()) && StringUtils.isBlank(value.getMessage())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(
                    "Field 'message' is mandatory when 'approved' field is false"
            ).addConstraintViolation();
            return false;
        }

        return true;
    }


}
