/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedInstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ArchivedEntityMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.MemberMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.MemberRequestMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ParagraphMapper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityBuilder.class);
    private final InstitutionalPageMapper institutionalPageMapper;
    private final ParagraphMapper paragraphMapper;
    private final MemberMapper memberMapper;
    private final MemberRequestMapper memberRequestMapper;
    private final ArchivedEntityMapper archivedEntityMapper;

    public MemberEntity buildWPLeader(UUID userId, InstitutionalPageEntity institutionalPageEntity) {
        MemberEntity memberEntity = this.memberMapper.toMemberEntity(userId, Boolean.valueOf(true), institutionalPageEntity);
        return memberEntity;
    }

    public MemberEntity buildRegularMember(UUID userId, UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPageEntity = ((InstitutionalPageEntity.InstitutionalPageEntityBuilder)InstitutionalPageEntity.builder().id(institutionalPageId)).build();
        MemberEntity memberEntity = this.memberMapper.toMemberEntity(userId, Boolean.valueOf(false), institutionalPageEntity);
        return memberEntity;
    }

    public MemberRequestEntity buildInvitation(UUID institutionalPageId, UUID invitedUserId, boolean wpLeader, String message) {
        return this.memberRequestMapper.toMemberRequestEntity(invitedUserId, institutionalPageId, MemberRequestType.INVITATION, wpLeader, message);
    }

    public MemberRequestEntity buildJoinRequest(UUID institutionalPageId, UUID invitedUserId, String message) {
        return this.memberRequestMapper.toMemberRequestEntity(invitedUserId, institutionalPageId, MemberRequestType.JOIN_REQUEST, false, message);
    }

    public InstitutionalPageEntity buildInstitutionalPage(UUID userId, InstitutionalPageEntity parentInstitutionalPageEntity, InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageMapper.toEntity(inputCreateInstitutionalPageDto);
        this.updateAssociationsForSave(institutionalPageEntity);
        UUID parentInstitutionalPageId = inputCreateInstitutionalPageDto.getParentInstitutionalPageId();
        institutionalPageEntity.setParentInstitutionalPageId(parentInstitutionalPageId);
        LinkedList<MemberEntity> memberEntities = new LinkedList<MemberEntity>();
        LinkedList<UUID> ancestorIPs = new LinkedList<UUID>();
        if (parentInstitutionalPageEntity == null) {
            memberEntities.add(this.buildWPLeader(userId, institutionalPageEntity));
        } else {
            ancestorIPs.addAll(parentInstitutionalPageEntity.getAncestorInstitutionalPageIds());
            ancestorIPs.addLast(parentInstitutionalPageEntity.getId());
        }
        institutionalPageEntity.setMembers(memberEntities);
        institutionalPageEntity.setAncestorInstitutionalPageIds(ancestorIPs);
        institutionalPageEntity.setMaintainer(userId);
        institutionalPageEntity.setToDelete(false);
        institutionalPageEntity.setUpdateLockedBy(null);
        institutionalPageEntity.setName(institutionalPageEntity.getName().trim());
        return institutionalPageEntity;
    }

    public void updateAssociationsForSave(InstitutionalPageEntity institutionalPage) {
        ((List)Optional.ofNullable(institutionalPage.getMembers()).orElse(new LinkedList())).forEach(member -> member.setInstitutionalPage(institutionalPage));
        ((List)Optional.ofNullable(institutionalPage.getParagraphs()).orElse(new LinkedList())).forEach(paragraph -> paragraph.setInstitutionalPage(institutionalPage));
    }

    public InstitutionalPageEntity cloneInstitutionalPageEntity(InstitutionalPageEntity institutionalPageEntity) {
        InstitutionalPageEntity clonedInstitutionalPageEntity = this.institutionalPageMapper.clone(institutionalPageEntity);
        this.updateAssociationsForSave(clonedInstitutionalPageEntity);
        return clonedInstitutionalPageEntity;
    }

    public void updateEntity(InstitutionalPageEntity target, InstitutionalPageEntity source) {
        this.institutionalPageMapper.updateEntity(target, source);
        this.updateAssociationsForSave(target);
    }

    public void updateEntity(InstitutionalPageEntity institutionalPageEntity, InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        this.institutionalPageMapper.updateEntity(institutionalPageEntity, inputUpdateInstitutionalPageDto);
        if (institutionalPageEntity.getParagraphs() == null) {
            institutionalPageEntity.setParagraphs(new ArrayList());
        }
        institutionalPageEntity.getParagraphs().clear();
        if (inputUpdateInstitutionalPageDto.getParagraphs() != null) {
            List updatedParagraphs = this.paragraphMapper.inputParagraphListToParagraphEntityList(inputUpdateInstitutionalPageDto.getParagraphs());
            institutionalPageEntity.getParagraphs().addAll(updatedParagraphs);
        }
        this.updateAssociationsForSave(institutionalPageEntity);
    }

    public ArchivedInstitutionalPageEntity buildArchivedEntity(InstitutionalPageEntity institutionalPageEntity) {
        ArchivedInstitutionalPageEntity archivedInstitutionalPage = this.archivedEntityMapper.toArchiveEntity(institutionalPageEntity);
        this.updateAssociationsForSave(archivedInstitutionalPage);
        return archivedInstitutionalPage;
    }

    public void updateAssociationsForSave(ArchivedInstitutionalPageEntity archivedInstitutionalPage) {
        ((List)Optional.ofNullable(archivedInstitutionalPage.getMembers()).orElse(new LinkedList())).forEach(member -> member.setInstitutionalPage(archivedInstitutionalPage));
        ((List)Optional.ofNullable(archivedInstitutionalPage.getParagraphs()).orElse(new LinkedList())).forEach(paragraph -> paragraph.setInstitutionalPage(archivedInstitutionalPage));
    }

    @Generated
    public EntityBuilder(InstitutionalPageMapper institutionalPageMapper, ParagraphMapper paragraphMapper, MemberMapper memberMapper, MemberRequestMapper memberRequestMapper, ArchivedEntityMapper archivedEntityMapper) {
        this.institutionalPageMapper = institutionalPageMapper;
        this.paragraphMapper = paragraphMapper;
        this.memberMapper = memberMapper;
        this.memberRequestMapper = memberRequestMapper;
        this.archivedEntityMapper = archivedEntityMapper;
    }
}

