package com.finconsgroup.itserr.marketplace.metadata.bs.controller;

import com.finconsgroup.itserr.marketplace.metadata.bs.api.MetadataApi;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * Metadata controller.
 */
@RestController
@RequiredArgsConstructor
public class MetadataController implements MetadataApi {

    private final MetadataService metadataService;

    @Override
    public OutputMetadataDto create(final InputCreateMetadataDto request) {
        return metadataService.create(request);
    }

    @Override
    public OutputMetadataDto deleteById(final UUID id) {
        return metadataService.deleteById(id);
    }

}
