package com.finconsgroup.itserr.marketplace.metadata.bs.dto;

import com.finconsgroup.itserr.marketplace.metadata.bs.enums.MetadataCategoryEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.UUID;

/**
 * Metadata DTO.
 */
@Schema(
        name = "Metadata",
        description = "Represents a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataDto {

    /**
     * Name field length.
     */
    public static final int NAME_LENGTH = 50;

    /**
     * Description field length.
     */
    public static final int DESCRIPTION_LENGTH = 2000;

    @Schema(
            description = "Metadata id",
            example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotBlank
    private UUID id;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    @NotBlank
    @Size(max = NAME_LENGTH)
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    @Size(max = DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryEnum category;

    @Schema(description = "The ID of the creator", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;

    @Schema(description = "Metadata fields")
    @NotEmpty
    private List<OutputMetadataFieldDto> fields;

}
