package com.finconsgroup.itserr.marketplace.metadata.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Metadata field value type enumeration.
 */
@Schema(
        name = "MetadataFieldType",
        description = "Metadata field value types"
)
public enum OutputMetadataFieldType {
    @Schema(description = "String")
    STRING,
    @Schema(description = "Time")
    TIME,
    @Schema(description = "Time interval")
    TIME_INTERVAL,
    @Schema(description = "List of times")
    TIMES_LISTOF,
    @Schema(description = "Text")
    TEXT,
    @Schema(description = "Boolean")
    BOOLEAN,
    @Schema(description = "Number")
    NUMBER,
    @Schema(description = "Geo JSON")
    GEO_JSON,
}
