package com.finconsgroup.itserr.marketplace.metadata.bs.messaging;

import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Message Producer responsible for publishing metadata-related resource messages
 */
public interface ResourceProducer {

    /**
     * Filter key used to identify the service in the message metadata.
     */
    String SERVICE_FILTER_KEY = "service";
    /**
     * Filter value associated with the metadata service.
     */
    String SERVICE_FILTER_VALUE = "metadata";

    /**
     * Publishes a message for created resource.
     *
     * @param resource the resource that was created
     */
    void publishCreatedResource(@NonNull OutputMetadataDto resource);

    /**
     * Publishes a message for deleted resource.
     *
     * @param documentId Document id.
     * @throws WP2MessagingException if message cannot be sent.
     */
    void publishDeletedResource(@NonNull UUID documentId);
}
