package com.finconsgroup.itserr.marketplace.metadata.dm.repository;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

import java.util.UUID;

/**
 * {@link MetadataEntity} repository.
 */
@Repository
public interface MetadataRepository extends JpaRepository<MetadataEntity, UUID>, JpaSpecificationExecutor<MetadataEntity> {

    /**
     * Counts metadata having the given name.
     *
     * @param name Name.
     * @return Number of metadata matching the name.
     */
    int countByNameIgnoreCase(@NonNull String name);

    Page<MetadataEntity> findAllByCategory(MetadataCategoryEnum category, Pageable pageable);
}
