/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.api;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Metadata", description="The Metadata API: it provides endpoints for retrieving, creating, and deleting metadata.")
@SecurityRequirement(name="BearerAuth")
public interface MetadataApi {
    @Operation(summary="Retrieve all metadata", parameters={@Parameter(name="category", description="The category of the metadata"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC")}, responses={@ApiResponse(responseCode="200", description="OK")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/metadata"}, produces={"application/json"})
    public Page<OutputMetadataPreviewDto> findAll(@RequestParam(required=false) MetadataCategoryEnum var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="Retrieves a metadata by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/metadata/{metadataId}"}, produces={"application/json"})
    public OutputMetadataDto findById(@PathVariable(value="metadataId") UUID var1);

    @Operation(summary="Creates a new metadata", description="Creates a new metadata.", responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="409", description="Another metadata exists with the same name", content={@Content})})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(path={"/metadata"}, consumes={"application/json"}, produces={"application/json"})
    public OutputMetadataDto create(@Valid @RequestBody InputCreateMetadataDto var1);

    @Operation(summary="Deletes a metadata by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="NOT FOUND")})
    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"/metadata/{metadataId}"}, produces={"application/json"})
    public OutputMetadataDto deleteById(@PathVariable(value="metadataId") UUID var1);

    @Operation(summary="Retrieve all metadata fields by Id", parameters={@Parameter(name="metadataId", description="The Id of the metadata"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC")}, responses={@ApiResponse(responseCode="200", description="OK")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/metadata/{metadataId}/fields"}, produces={"application/json"})
    public Page<OutputMetadataFieldDto> findAllFieldsById(@PathVariable(value="metadataId") UUID var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="Retrieve all metadata fields for every category", parameters={@Parameter(name="category", description="The category of the metadata"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC")}, responses={@ApiResponse(responseCode="200", description="OK")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/metadata/fields"}, produces={"application/json"})
    public Page<OutputMetadataFieldExtDto> findAllFields(@RequestParam(required=false) MetadataCategoryEnum var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);
}

