/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.bs.client.MetricDmClient;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInterestsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputMetricsInterestWeightsConfigurationDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricInterestService;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricInterestService
implements MetricInterestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricInterestService.class);
    private static final long INTEREST_WEIGHTS_TIMEOUT_SECS = 300L;
    private final MetricDmClient metricDmClient;
    private OutputMetricsInterestWeightsConfigurationDto interestWeights;
    private Long interestWeightTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputMetricsInterestsDto getUserMetricsInterests(OutputMetricsDto metrics) {
        DefaultMetricInterestService defaultMetricInterestService = this;
        synchronized (defaultMetricInterestService) {
            if (this.interestWeights == null || this.interestWeightTimeout == null || this.interestWeightTimeout < System.currentTimeMillis()) {
                OutputMetricsInterestWeightsConfigurationDto actualInterestWeights = Optional.ofNullable(this.metricDmClient.getInterestWeights()).orElseGet(OutputMetricsInterestWeightsConfigurationDto::new);
                actualInterestWeights.entrySet().removeIf(entry -> entry.getValue() == null);
                this.interestWeights = actualInterestWeights;
                this.interestWeightTimeout = System.currentTimeMillis() + 300000L;
            }
        }
        OutputMetricsInterestsDto metricsInterests = new OutputMetricsInterestsDto();
        metrics.forEach((metric, value) -> metricsInterests.put(metric, (Object)(value * (Double)this.interestWeights.getOrDefault(metric, (Object)0.0))));
        return metricsInterests;
    }

    public double getTotalInterest(OutputMetricsInterestsDto metrics) {
        return metrics != null ? metrics.values().stream().filter(Objects::nonNull).mapToDouble(e -> e).sum() : 0.0;
    }

    @Generated
    public DefaultMetricInterestService(MetricDmClient metricDmClient) {
        this.metricDmClient = metricDmClient;
    }
}

