/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.dm.bs.QueuedMVUpdater;
import com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.MVUpdateConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.MetricEventNotFoundException;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.BeneficiaryMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricEventMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricTypeMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.repository.MetricEventBeneficiaryRepository;
import com.finconsgroup.itserr.marketplace.metrics.dm.repository.MetricEventRepository;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricEventService;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultMetricEventService
implements MetricEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricEventService.class);
    private static final long UPDATE_DELAY_MS = 1000L;
    private final MVUpdateConfigurationProperties config;
    private final MetricEventRepository metricEventRepository;
    private final MetricEventBeneficiaryRepository metricEventBeneficiaryRepository;
    private final MetricEventMapper metricEventMapper;
    private final MetricTypeMapper metricTypeMapper;
    private final BeneficiaryMapper beneficiaryMapper;
    private final QueuedMVUpdater queuedMVUpdater;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputMetricEventDto create(@NonNull MetricDtoType metric, @NonNull InputCreateMetricEventDto request) {
        List savedBeneficiaries;
        UUID metricEventId;
        MetricEventEntity savedMetricEventEntity;
        MetricEventEntity metricEventEntity = this.metricEventMapper.toEntity(metric, request);
        try {
            savedMetricEventEntity = (MetricEventEntity)this.metricEventRepository.saveAndFlush((Object)metricEventEntity);
            metricEventId = savedMetricEventEntity.getId();
        }
        catch (DataIntegrityViolationException e) {
            throw new MetricEventConflictException((Throwable)e);
        }
        List requestBeneficiaries = request.getBeneficiaries();
        if (requestBeneficiaries != null && !requestBeneficiaries.isEmpty()) {
            List<MetricEventBeneficiaryEntity> beneficiariesEntities = requestBeneficiaries.stream().map(b -> this.beneficiaryMapper.toEntity(b, metric, metricEventId)).toList();
            savedBeneficiaries = this.metricEventBeneficiaryRepository.saveAllAndFlush(beneficiariesEntities);
        } else {
            savedBeneficiaries = List.of();
        }
        if (this.config.isOnNewEvents()) {
            this.queuedMVUpdater.updateAfter(1000L);
        }
        return this.metricEventMapper.toDto(savedMetricEventEntity, savedBeneficiaries);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetricEventRefDto> findAll(@NonNull MetricDtoType metric, @NonNull Pageable pageable) {
        MetricType entityMetric = this.metricTypeMapper.metricDtoTypeToMetricType(metric);
        return this.metricEventRepository.findAllByMetric(entityMetric, pageable).map(arg_0 -> ((MetricEventMapper)this.metricEventMapper).toRefDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputMetricEventDto findById(@NonNull MetricDtoType metric, @NonNull UUID metricEventId) {
        MetricType entityMetric = this.metricTypeMapper.metricDtoTypeToMetricType(metric);
        List beneficiaries = this.metricEventBeneficiaryRepository.findByMetricAndEventId(entityMetric, metricEventId);
        return this.metricEventRepository.findById((Object)MetricEventEntity.MetricEventId.of((MetricType)entityMetric, (UUID)metricEventId)).map(e -> this.metricEventMapper.toDto(e, (Collection)beneficiaries)).orElseThrow(() -> new MetricEventNotFoundException(metricEventId));
    }

    @Generated
    public DefaultMetricEventService(MVUpdateConfigurationProperties config, MetricEventRepository metricEventRepository, MetricEventBeneficiaryRepository metricEventBeneficiaryRepository, MetricEventMapper metricEventMapper, MetricTypeMapper metricTypeMapper, BeneficiaryMapper beneficiaryMapper, QueuedMVUpdater queuedMVUpdater) {
        this.config = config;
        this.metricEventRepository = metricEventRepository;
        this.metricEventBeneficiaryRepository = metricEventBeneficiaryRepository;
        this.metricEventMapper = metricEventMapper;
        this.metricTypeMapper = metricTypeMapper;
        this.beneficiaryMapper = beneficiaryMapper;
        this.queuedMVUpdater = queuedMVUpdater;
    }
}

