package com.finconsgroup.itserr.marketplace.metrics.dm;

import com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.HibernateConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.MVUpdateConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.web.config.EnableSpringDataWebSupport;

/**
 * Main Spring Boot application class for the Metrics Data Management service.
 */
@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "Metrics DM API",
        description = "API definition of the Metrics Microservice",
        version = "1.0.0"
))
@EnableSpringDataWebSupport(pageSerializationMode = EnableSpringDataWebSupport.PageSerializationMode.VIA_DTO)
@EnableConfigurationProperties({
        MVUpdateConfigurationProperties.class,
        HibernateConfigurationProperties.class,
})
public class MetricsDmApplication {

    /**
     * The main method that starts the Spring Boot application.
     *
     * @param args command line arguments passed to the application
     */
    public static void main(String[] args) {
        SpringApplication.run(MetricsDmApplication.class, args);
    }

}
