package com.finconsgroup.itserr.marketplace.metrics.dm.api;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputUserInterestInfoDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.UUID;

/**
 * This interface defines the contract for REST API endpoints related to interest.
 */
@Tag(
        name = "Interest",
        description = "The Interest API: it provides endpoints for managing interest."
)
@SecurityRequirement(name = "BearerAuth")
public interface InterestApi {

    /**
     * Retrieves interest information for a user.
     */
    @Operation(
            summary = "get user interest information",
            responses = {
                    @ApiResponse(responseCode = "200", description = "OK"),
            }
    )
    @GetMapping(value = "/metrics/users/{userId}/interest", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseStatus(HttpStatus.OK)
    OutputUserInterestInfoDto getUserInterestInfo(
            @PathVariable("userId") UUID userId);

}
