/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.api;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricsInterestWeightsConfigurationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Diagnostics", description="Diagnostics API: provides endpoints used for debugging and runtime analysis.")
@SecurityRequirement(name="BearerAuth")
public interface DiagnosticsApi {
    @Operation(summary="Download log file", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/metrics/diagnostics/download-logs"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadLogs();

    @Operation(summary="create metricEvent", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/metrics/diagnostics/metrics/{metricId}/events"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputMetricEventDto createMetricEvent(@PathVariable(value="metricId") MetricDtoType var1, @Valid @RequestBody InputCreateMetricEventDto var2);

    @Operation(summary="find all MetricEvents", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/metrics/diagnostics/metrics/{metricId}/events"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputMetricEventRefDto> findAll(@PathVariable(value="metricId") MetricDtoType var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="id", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="find metricEvent by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @GetMapping(value={"/metrics/diagnostics/metrics/{metricId}/events/{metricEventId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputMetricEventDto findById(@PathVariable(value="metricId") MetricDtoType var1, @PathVariable(value="metricEventId") UUID var2);

    @Operation(summary="Force update metrics", responses={@ApiResponse(responseCode="202", description="Accepted (sync=false, will be processed soon)"), @ApiResponse(responseCode="204", description="Done (sync=true)")})
    @PutMapping(value={"/metrics/diagnostics/metrics"})
    public ResponseEntity<Void> updateMetrics(@RequestParam(name="sync", required=false, defaultValue="false") boolean var1);

    @Operation(summary="Retrieve metrics interest weight configuration", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/metrics/diagnostics/config/metrics-weights"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputMetricsInterestWeightsConfigurationDto getInterestWeights();
}

