/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.feeder.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.metrics.feeder.client.MetricsBsClient;
import com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties.MetricsFeederConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.favouriteuserbs.FavouriteItemMessageBodyDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.feeder.messaging.AbstractMetricEventConsumer;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component(value="favouriteUserEventConsumer")
public class FavouriteUserEventConsumer
extends AbstractMetricEventConsumer<FavouriteItemMessageBodyDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteUserEventConsumer.class);

    public FavouriteUserEventConsumer(MetricsFeederConfigurationProperties config, MetricsBsClient metricsBsClient) {
        super(metricsBsClient, MetricDtoType.CATALOG_ITEM_FAVOURITE, config.getMessaging().getFavouriteUser().getResourceCreatedEventType(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void fillMetricEvent(@NonNull InputCreateMetricEventDto.InputCreateMetricEventDtoBuilder metricEventBuilder, @NonNull FavouriteItemMessageBodyDto resourcePayload, @NonNull CloudEvent event) throws AbstractMetricEventConsumer.ValidationException {
        if (StringUtils.isBlank((CharSequence)resourcePayload.getCategory())) {
            throw new AbstractMetricEventConsumer.ValidationException("no category");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)resourcePayload.getCategory(), (CharSequence)"CATALOG")) {
            throw new AbstractMetricEventConsumer.ValidationException("not a catalog item favourite (type=" + resourcePayload.getCategory() + ")", false);
        }
        if (resourcePayload.getAdditionalData() == null) {
            throw new AbstractMetricEventConsumer.ValidationException("no additional data");
        }
        if (StringUtils.isBlank((CharSequence)((FavouriteItemMessageBodyDto.AdditionalData)resourcePayload.getAdditionalData()).getItemName())) {
            throw new AbstractMetricEventConsumer.ValidationException("no item name");
        }
        String itemName = ((FavouriteItemMessageBodyDto.AdditionalData)resourcePayload.getAdditionalData()).getItemName();
        metricEventBuilder.resourceId(itemName);
    }
}

