/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.api;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="UserNotificationApi", description="The UserNotificationApi API: it provides endpoints for retrieving, creating, updating, and deleting Notifications for a user.")
@SecurityRequirement(name="BearerAuth")
public interface UserNotificationApi {
    @Operation(summary="create users notifications", responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PostMapping(value={"/notification/notifications"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public List<OutputUserNotificationDto> createNotification(@Valid @RequestBody InputCreateUserNotificationDto var1, @RequestHeader(name="Accept-Language", required=false) String var2);

    @Operation(summary="patch all user notifications, mark notification as read/unread", responses={@ApiResponse(responseCode="204", description="OK")})
    @PatchMapping(value={"/notification/notifications"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchAll(@Valid @RequestBody InputPatchUserNotificationsDto var1);

    @Operation(summary="patch notification by id, mark notification as read/unRead or archive/un-archive", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PatchMapping(value={"/notification/notifications/{id}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPatchUserNotificationDto patchUserNotificationById(@PathVariable(value="id") UUID var1, @Valid @RequestBody InputPatchUserNotificationDto var2);

    @Operation(summary="delete a user notification by id", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/notification/notifications/{id}"}, produces={"application/json"})
    public void deleteUserNotificationById(@PathVariable(value="id") UUID var1);
}

