/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.client;

import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputNotificationTemplateDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import jakarta.validation.Valid;
import java.util.List;
import java.util.UUID;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

public interface NotificationDmClient {
    @GetMapping(value={"/notification/notifications/{id}"}, produces={"application/json"})
    public OutputLocalizedUserNotificationDto findById(@PathVariable(value="id") UUID var1, @RequestHeader(name="Accept-Language", required=false) String var2);

    @PostMapping(value={"/notification/notifications"}, consumes={"application/json"}, produces={"application/json"})
    public List<OutputUserNotificationDto> create(@Valid @RequestBody InputCreateUserNotificationDto var1, @RequestHeader(name="Accept-Language", required=false) String var2);

    @PatchMapping(value={"/notification/notifications"}, consumes={"application/json"})
    public void patchAll(@Valid @RequestBody InputPatchUserNotificationsDto var1);

    @PatchMapping(value={"/notification/notifications/{id}"}, consumes={"application/json"}, produces={"application/json"})
    public OutputPatchUserNotificationDto patchById(@NonNull @PathVariable(value="id") UUID var1, @Valid @RequestBody InputPatchUserNotificationDto var2);

    @DeleteMapping(value={"/notification/notifications/{id}"}, produces={"application/json"})
    public void deleteById(@NonNull @PathVariable(value="id") UUID var1);

    @GetMapping(value={"/notification/notifications/templates/{notificationType}"}, produces={"application/json"})
    public List<OutputNotificationTemplateDto> getMessageTemplatesByType(@NonNull @PathVariable(value="notificationType") String var1);
}

