/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.notification.bs.api.UserNotificationApi;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.service.UserNotificationService;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserNotificationController
implements UserNotificationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserNotificationController.class);
    private final UserNotificationService userNotificationService;

    public List<OutputUserNotificationDto> createNotification(InputCreateUserNotificationDto inputCreateUserNotificationDto, String acceptLanguage) {
        return this.userNotificationService.create(inputCreateUserNotificationDto, acceptLanguage);
    }

    public void patchAll(InputPatchUserNotificationsDto request) {
        this.userNotificationService.patchAll(request);
    }

    public OutputPatchUserNotificationDto patchUserNotificationById(UUID notificationId, InputPatchUserNotificationDto inputPatchUserNotificationDto) {
        JwtTokenHolder.getUserIdOrThrow();
        return this.userNotificationService.patchById(notificationId, inputPatchUserNotificationDto);
    }

    public void deleteUserNotificationById(UUID notificationId) {
        JwtTokenHolder.getUserIdOrThrow();
        this.userNotificationService.deleteById(notificationId);
    }

    @Generated
    public UserNotificationController(UserNotificationService userNotificationService) {
        this.userNotificationService = userNotificationService;
    }
}

