/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.NotificationTemplateEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@Entity
@Table(name="notification_template")
public class NotificationTemplateEntity
extends AbstractUUIDEntity {
    @Column(name="notification_type", nullable=false, length=100)
    private String notificationType;
    @Column(name="language_code", nullable=false, length=5)
    private String languageCode;
    @Column(name="message_text", nullable=false)
    private String text;
    @Column(name="creation_time", nullable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Version
    @Column(name="version", nullable=false)
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @Generated
    protected NotificationTemplateEntity(NotificationTemplateEntityBuilder<?, ?> b) {
        super(b);
        this.notificationType = b.notificationType;
        this.languageCode = b.languageCode;
        this.text = b.text;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static NotificationTemplateEntityBuilder<?, ?> builder() {
        return new NotificationTemplateEntityBuilderImpl();
    }

    @Generated
    public String getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    @Generated
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "NotificationTemplateEntity(notificationType=" + this.getNotificationType() + ", languageCode=" + this.getLanguageCode() + ", text=" + this.getText() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationTemplateEntity)) {
            return false;
        }
        NotificationTemplateEntity other = (NotificationTemplateEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$notificationType = this.getNotificationType();
        String other$notificationType = other.getNotificationType();
        if (this$notificationType == null ? other$notificationType != null : !this$notificationType.equals(other$notificationType)) {
            return false;
        }
        String this$languageCode = this.getLanguageCode();
        String other$languageCode = other.getLanguageCode();
        if (this$languageCode == null ? other$languageCode != null : !this$languageCode.equals(other$languageCode)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationTemplateEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $notificationType = this.getNotificationType();
        result = result * 59 + ($notificationType == null ? 43 : $notificationType.hashCode());
        String $languageCode = this.getLanguageCode();
        result = result * 59 + ($languageCode == null ? 43 : $languageCode.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public NotificationTemplateEntity() {
    }
}

