/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.mapper;

import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.UserNotificationEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.MapperConfiguration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mapstruct.AfterMapping;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.springframework.lang.NonNull;

@Mapper(config=MapperConfiguration.class)
public interface UserNotificationMapper {
    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="read", ignore=true), @Mapping(target="archived", ignore=true), @Mapping(target="lastReadTime", ignore=true), @Mapping(target="user", ignore=true)})
    public UserNotificationEntity toEntityWithoutUser(InputCreateUserNotificationDto var1);

    @NonNull
    default public List<UserNotificationEntity> toEntities(InputCreateUserNotificationDto src) {
        if (src == null || src.getUsers() == null || src.getUsers().isEmpty()) {
            return new ArrayList<UserNotificationEntity>();
        }
        LinkedHashSet users = new LinkedHashSet(src.getUsers());
        return users.stream().map(user -> {
            UserNotificationEntity entity = this.toEntityWithoutUser(src);
            entity.setUser(user);
            return entity;
        }).toList();
    }

    public OutputUserNotificationDto toDto(UserNotificationEntity var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="read", source="read"), @Mapping(target="archived", source="archived")})
    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault=true)
    public void patchEntity(InputPatchUserNotificationDto var1, @MappingTarget UserNotificationEntity var2);

    public OutputPatchUserNotificationDto toPatchDto(UserNotificationEntity var1);

    @AfterMapping
    default public void afterPatchEntity(@NotNull InputPatchUserNotificationDto dto, @MappingTarget UserNotificationEntity entity) {
        if (Boolean.TRUE.equals(dto.getRead())) {
            entity.setLastReadTime(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS));
        }
    }
}

