/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.InputPatchUserNotificationsDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputPatchUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.dm.dto.UserDto;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.ArchivedUserNotificationEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.entity.UserNotificationEntity;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.ArchivedUserNotificationMapper;
import com.finconsgroup.itserr.marketplace.notification.dm.mapper.UserNotificationMapper;
import com.finconsgroup.itserr.marketplace.notification.dm.repository.ArchivedUserNotificationRepository;
import com.finconsgroup.itserr.marketplace.notification.dm.repository.UserNotificationRepository;
import com.finconsgroup.itserr.marketplace.notification.dm.service.LocalizedUserNotificationService;
import com.finconsgroup.itserr.marketplace.notification.dm.service.UserNotificationService;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultUserNotificationService
implements UserNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserNotificationService.class);
    private final UserNotificationRepository userNotificationRepository;
    private final UserNotificationMapper userNotificationMapper;
    private final ArchivedUserNotificationRepository archivedUserNotificationRepository;
    private final ArchivedUserNotificationMapper archivedUserNotificationMapper;
    private final LocalizedUserNotificationService localizedUserNotificationService;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public List<OutputUserNotificationDto> create(@NotNull InputCreateUserNotificationDto request) {
        List entities = this.userNotificationMapper.toEntities(request);
        for (UserNotificationEntity entity : entities) {
            entity.setRead(Boolean.FALSE);
            entity.setArchived(Boolean.FALSE);
        }
        List savedEntities = this.userNotificationRepository.saveAllAndFlush((Iterable)entities);
        return savedEntities.stream().map(arg_0 -> ((UserNotificationMapper)this.userNotificationMapper).toDto(arg_0)).toList();
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @NotNull
    public OutputPatchUserNotificationDto patchById(@NonNull UserDto user, @NotNull UUID notificationId, @NotNull InputPatchUserNotificationDto inputPatchUserNotificationDto) {
        UserNotificationEntity userNotificationEntity = this.findByIdOrThrow(user, notificationId);
        this.userNotificationMapper.patchEntity(inputPatchUserNotificationDto, userNotificationEntity);
        UserNotificationEntity savedUserNotificationEntity = (UserNotificationEntity)this.userNotificationRepository.save((Object)userNotificationEntity);
        return this.userNotificationMapper.toPatchDto(savedUserNotificationEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NonNull UserDto user, @NotNull UUID notificationId) {
        UserNotificationEntity userNotificationEntity = this.findByIdOrThrow(user, notificationId);
        ArchivedUserNotificationEntity archivedUserNotificationEntity = this.archivedUserNotificationMapper.toArchivedEntity(userNotificationEntity);
        this.archivedUserNotificationRepository.save((Object)archivedUserNotificationEntity);
        this.userNotificationRepository.deleteById((Object)notificationId);
    }

    private UserNotificationEntity findByIdOrThrow(@NonNull UserDto user, @NonNull UUID notificationId) {
        return (UserNotificationEntity)this.userNotificationRepository.findByUserAndId(user.id().toString(), user.username(), user.email(), notificationId).orElseThrow(() -> new WP2ResourceNotFoundException(notificationId));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void patchAll(@NonNull UserDto user, @NonNull InputPatchUserNotificationsDto request) {
        if (request.getRead() != null) {
            this.userNotificationRepository.updateRead(user.id().toString(), user.username(), user.email(), request.getRead().booleanValue());
        }
    }

    @Generated
    public DefaultUserNotificationService(UserNotificationRepository userNotificationRepository, UserNotificationMapper userNotificationMapper, ArchivedUserNotificationRepository archivedUserNotificationRepository, ArchivedUserNotificationMapper archivedUserNotificationMapper, LocalizedUserNotificationService localizedUserNotificationService) {
        this.userNotificationRepository = userNotificationRepository;
        this.userNotificationMapper = userNotificationMapper;
        this.archivedUserNotificationRepository = archivedUserNotificationRepository;
        this.archivedUserNotificationMapper = archivedUserNotificationMapper;
        this.localizedUserNotificationService = localizedUserNotificationService;
    }
}

