package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.List;

/**
 * DTO for subscribed participant.
 */
@Schema(name = "EventSubscribedParticipantDto", description = "DTO representing a subscribed participant")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class EventSubscribedParticipantDto {

    @Schema(description = "The ID of the subscribed participant", example = "123e4567-e89b-12d3-a456-426614174002")
    private String id;

    @Schema(description = "The ID of the event", example = "123e4567-e89b-12d3-a456-426614174002")
    private String eventId;

    @Schema(description = "The ID of the subscribed participant user profile", example = "123e4567-e89b-12d3-a456-426614174002")
    private String userId;

    @Schema(description = "First Name", example = "John")
    private String firstName;

    @Schema(description = "Last Name", example = "Doe")
    private String lastName;

    @Schema(description = "Email", example = "john.doe@example.com")
    private String email;

    @Schema(description = "orcid", example = "00000-00000-00000-00000")
    private String orcid;

    @Schema(description = "List of programs, participant has subscribed to")
    List<SubscribedProgramDto> subscribedPrograms;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}
