package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for Registered Author search field.
 */
@Builder
@Schema(
    title = "Registered Author Dto",
    description = "Represents the payload for registered author field"
)
@Data
public class RegisteredAuthorDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private String id;

    @Schema(description = "First Name", example = "John")
    private String firstName;

    @Schema(description = "Last Name", example = "Doe")
    private String lastName;

    @Schema(description = "Email", example = "john.doe@example.com")
    private String email;

    @Schema(description = "orcid", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Location")
    private LocationDto location;
}
