package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.LocalDate;

/**
 * It represents the persistent structure of publication field for search.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class Publication {

    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.ISO_DATE)
    private LocalDate date;

    @Field(type = FieldType.Object)
    private Location location;
}
