/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.CatalogSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.DefaultSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogFavouriteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Catalog;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.CatalogMapper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CatalogRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.service.CatalogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultCatalogService
implements CatalogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCatalogService.class);
    private final CatalogRepository catalogRepository;
    private final CatalogMapper catalogMapper;
    private final CatalogSearchProperties catalogSearchProperties;
    private final Map<String, String> sortFilterPropertyMap;

    public DefaultCatalogService(CatalogRepository catalogRepository, CatalogMapper catalogMapper, CatalogSearchProperties catalogSearchProperties, DefaultSearchProperties defaultSearchProperties) {
        this.catalogRepository = catalogRepository;
        this.catalogMapper = catalogMapper;
        this.catalogSearchProperties = catalogSearchProperties;
        this.sortFilterPropertyMap = this.buildSortFilterPropertyMap(catalogSearchProperties.search(), defaultSearchProperties.search().sortFilterPropertyMap());
    }

    @Transactional
    @NonNull
    public OutputCatalogDto upsertDocument(@NonNull InputCatalogDto dto) {
        Catalog catalog = this.catalogMapper.toEntity(dto);
        Catalog savedCatalog = (Catalog)this.catalogRepository.save((Object)catalog);
        return this.catalogMapper.toDto(savedCatalog);
    }

    @Transactional(readOnly=true)
    @NonNull
    public OutputCatalogDto getDocument(@NonNull String id) {
        Catalog savedCatalog = (Catalog)this.catalogRepository.findById((Object)id).orElseThrow(() -> new WP2ResourceNotFoundException("search_dm_catalog_not_found"));
        return this.catalogMapper.toDto(savedCatalog);
    }

    @Transactional
    public void deleteDocument(@NonNull String id) {
        if (!this.catalogRepository.existsById((Object)id)) {
            throw new WP2ResourceNotFoundException("search_dm_catalog_not_found");
        }
        this.catalogRepository.deleteById((Object)id);
    }

    public void deleteAll() {
        if (!this.catalogSearchProperties.search().enableDeleteAll()) {
            throw new WP2BusinessException("search_dm_catalog_delete_all_not_enabled");
        }
        this.catalogRepository.deleteAll();
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).build(), this.catalogSearchProperties.search().autoCompletion().sourceFields(), arg_0 -> ((CatalogMapper)this.catalogMapper).toAutoCompleteDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.catalogSearchProperties.search().autoCompletion().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchAutoCompleteDto.builder().category(Category.CATALOG.getId()).data(resultPage.getContent()).build());
    }

    @NonNull
    @Transactional(readOnly=true)
    public Page<OutputCatalogLocalSearchDto> getLocalSearch(String terms, String filters, @NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().terms(terms).queryFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap)).build();
        Pageable sortedPageable = this.applySort(pageable, this.catalogSearchProperties.search(), this.sortFilterPropertyMap);
        return this.search(searchRequest, this.catalogSearchProperties.search().local().sourceFields(), arg_0 -> ((CatalogMapper)this.catalogMapper).toLocalSearchDto(arg_0), sortedPageable);
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        Map searchResultAggregatedByType = this.searchByAggregation(SearchRequest.builder().terms(terms).build(), this.catalogSearchProperties.search().globalSearch().sourceFields(), this.catalogSearchProperties.search().globalSearch().topHitsLimit().intValue(), this.catalogSearchProperties.search().globalSearch().aggregation(), arg_0 -> ((CatalogMapper)this.catalogMapper).toGlobalSearchDataDto(arg_0));
        if (searchResultAggregatedByType.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputGlobalSearchDto> globalSearchResults = new ArrayList<OutputGlobalSearchDto>();
        searchResultAggregatedByType.forEach((type, results) -> globalSearchResults.add(OutputGlobalSearchDto.builder().category(Category.CATALOG.getId()).type(type).data(results).build()));
        return globalSearchResults;
    }

    @NonNull
    @Transactional(readOnly=true)
    public Page<OutputCatalogFavouriteDto> getFavourite(@NonNull List<String> ids, String filters, @NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().ids(ids).queryFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap)).build();
        Pageable sortedPageable = this.applySort(pageable, this.catalogSearchProperties.search(), this.sortFilterPropertyMap);
        return this.search(searchRequest, this.catalogSearchProperties.search().favourite().sourceFields(), arg_0 -> ((CatalogMapper)this.catalogMapper).toFavouriteDto(arg_0), sortedPageable);
    }

    @NonNull
    public Class<Catalog> getDocumentClass() {
        return Catalog.class;
    }

    @NonNull
    public SearchProperties getSearchProperties() {
        return this.catalogSearchProperties.search();
    }

    @NonNull
    public CustomQueryRepository getCustomQueryRepository() {
        return this.catalogRepository;
    }

    @NonNull
    public CustomAggregationRepository getCustomAggregationRepository() {
        return this.catalogRepository;
    }
}

