package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;

/**
 * It represents the payload for publication field of a search document.
 */
@Builder
@Schema(
    title = "DTO for Publication field of search document",
    description = "Represents the payload for publication field to create/update a search document"
)
@Data
public class PublicationDto {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateTimeFormats.ISO_DATE)
    @Schema(
        description = "Date",
        example = "2025-03-31")
    private LocalDate date;

    @Schema(
        description = "Location")
    private LocationDto location;

}
