package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.search.dm.converter.InstantPropertyValueConverter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.ValueConverter;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

/**
 * It represents the persistent structure of Institutional Page Search document for both Global and Local search.
 */
@SuppressWarnings("DefaultAnnotationParam")
@Document(
    indexName = "#{@environment.getProperty('search-dm.institutional-page.search.index-name','itserr-alias-wp2-search-institutional-page')}",
    createIndex = false,
    alwaysWriteMapping = false,
    writeTypeHint = WriteTypeHint.FALSE
)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class InstitutionalPage implements ScoredDocument {

    @Id
    private String id;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String name;

    @Field(type = FieldType.Keyword)
    private String workspaceFolderId;

    @Field(type = FieldType.Object)
    private RelatedPage parentInstitutionalPage;

    @Field(type = FieldType.Object)
    private List<RelatedPage> childInstitutionalPages;

    @Field(type = FieldType.Keyword)
    private String rootInstitutionalPageId;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant publicationTime;

    @Field(type = FieldType.Boolean)
    private Boolean published;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String rejectionMessage;

    @Field(type = FieldType.Keyword)
    private String category;

    @Field(type = FieldType.Keyword)
    private String moderationStatus;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String abstractContent;

    @Field(type = FieldType.Object)
    private Copyright copyright;

    @Field(type = FieldType.Object)
    private List<UserProfileMinimal> wpLeads;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private List<UserProfileMinimal> members;

    @Field(type = FieldType.Object)
    private UserProfileMinimal maintainer;

    @Field(type = FieldType.Object)
    private UserProfileMinimal lastModifiedBy;

    @Field(type = FieldType.Object)
    private List<Paragraph> paragraphs;

    @Field(type = FieldType.Keyword)
    private List<String> tags;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String imageUrl;

    @Field(type = FieldType.Object)
    private SupportedOs supportedOs;

    @Field(type = FieldType.Object)
    private Repositories repositories;

    @Field(type = FieldType.Object)
    private LinkedHashMap<String, String> additionalFields;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String userManualUrl;

    @MultiField(mainField = @Field(type = FieldType.Text),
        otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String faqsUrl;

    @Field(type = FieldType.Keyword)
    private String applicationVersion;

    @Field(type = FieldType.Keyword)
    private String applicationType;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String license;

    @Field(type = FieldType.Object)
    private List<Button> buttons;

    @Field(type = FieldType.Object)
    private List<Publication> publications;

    @Field(type = FieldType.Auto)
    private LinkedHashMap<String, String> externalLinks;

    @Field(type = FieldType.Keyword)
    private Set<String> allowedUserIds;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant creationTime;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant updateTime;

    @Field(type = FieldType.Boolean)
    private Boolean toDelete;

    @Field(type = FieldType.Boolean)
    private Boolean hasUpdatedVersion;

    @Transient
    private Double score;

    /**
     * It represents the persistent structure of related node (parent/child) for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class RelatedPage {

        @Field(type = FieldType.Keyword)
        private String institutionalPageId;

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String institutionalPageName;

        @Field(type = FieldType.Keyword)
        private String workspaceFolderId;

        @Field(type = FieldType.Keyword)
        private String category;

    }

    /**
     * It represents the persistent structure of paragraph field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Paragraph {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String content;

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String imageUrl;

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String resourceUrl;

        @Field(type = FieldType.Keyword)
        private List<String> labels;

    }

    /**
     * It represents the persistent structure of copyright field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Copyright {

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String text;

        @Field(type = FieldType.Keyword)
        private Integer year;
    }


    /**
     * It represents the persistent structure of supported os field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class SupportedOs {

        @Field(type = FieldType.Keyword)
        private String macOs;

        @Field(type = FieldType.Keyword)
        private String linux;

        @Field(type = FieldType.Keyword)
        private String windows;
    }

    /**
     * It represents the persistent structure of repositories field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Repositories {

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String repoName;

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String website;
    }

    /**
     * It represents the persistent structure of button field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Button {

        @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String label;

        @Field(type = FieldType.Keyword)
        private String link;

        @Field(type = FieldType.Keyword)
        private String buttonType;

        @Field(type = FieldType.Keyword)
        private String iconCssClass;
    }

    /**
     * It represents the persistent structure of publications field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Publication {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String name;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @Field(type = FieldType.Keyword)
        private String status;

        @Field(type = FieldType.Keyword)
        private String version;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String creatorEmail;

        @Field(type = FieldType.Object)
        private List<Author> authors;

        @Field(type = FieldType.Object)
        private Author maintainer;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant createTs;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant updateTs;

        @Field(type = FieldType.Keyword)
        private String type;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String url;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String licenseTitle;

        @Field(type = FieldType.Integer)
        private int numTags;
    }

}
