package com.finconsgroup.itserr.marketplace.search.dm.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum Category {
    INSTITUTIONAL_PAGE("InstitutionalPage"), EVENT("Event"), NEWS("News"), PEOPLE("People"), CATALOG("Catalog");

    private final String id;

    Category(String id) {
        this.id = id;
    }

    @JsonValue
    public String getId() {
        return id;
    }

    /**
     * It maps the name to a {@link Category} object
     *
     * @param id the id to map to category
     * @return {@link Category} instance if found
     * @throws IllegalArgumentException if no matching category instance found
     */
    public static Category ofId(String id) {
        for (Category category : Category.values()) {
            if (category.id.equalsIgnoreCase(id)) {
                return category;
            }
        }

        throw new IllegalArgumentException("Unsupported category : " + id);
    }
}
