package com.finconsgroup.itserr.marketplace.search.dm.service;

import org.springframework.lang.NonNull;

/**
 * Service for search document related operations.
 *
 * @param <I> the type of input dto for the document
 * @param <R> the type of output dto for the document
 */
public interface DocumentService<I, R> {
    /**
     * Creates a new document or updates an existing document entry based on the provided {@link R}
     *
     * @param dto the of type {@link I}
     * @return the created document of type {@link I}
     */
    @NonNull
    R upsertDocument(@NonNull I dto);

    /**
     * Fetches the document entry using the provided id
     *
     * @param id the id for the document
     * @return the dto of type {@link R} if found
     * @throws com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException if not found
     */
    @NonNull
    R getDocument(@NonNull String id);

    /**
     * Deletes the document entry using the provided id
     *
     * @param id the id for the document
     * @throws com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException if not found
     */
    void deleteDocument(@NonNull String id);

    /**
     * Deletes all the documents from the search index.
     */
    void deleteAll();
}
