/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.event;

import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;

public class UserProfileUpdatedEvent
extends ApplicationEvent {
    private final UserProfile oldUserProfile;

    public UserProfileUpdatedEvent(UserProfile source, UserProfile oldUserProfile) {
        super((Object)source);
        this.oldUserProfile = oldUserProfile;
    }

    public UserProfileUpdatedEvent(UserProfile source) {
        this(source, null);
    }

    public UserProfile getUserProfile() {
        return (UserProfile)this.source;
    }

    public boolean isUserProfileMinimalUpdated() {
        if (this.oldUserProfile == null) {
            return true;
        }
        UserProfile newUserProfile = this.getUserProfile();
        return !Objects.equals(newUserProfile.getFirstName(), this.oldUserProfile.getFirstName()) || !Objects.equals(newUserProfile.getLastName(), this.oldUserProfile.getLastName()) || !Objects.equals(newUserProfile.getEmail(), this.oldUserProfile.getEmail()) || !Objects.equals(newUserProfile.getOrcid(), this.oldUserProfile.getOrcid());
    }

    public boolean isLocationUpdated() {
        if (this.oldUserProfile == null) {
            return this.getUserProfile().getWorkingLocation() != null;
        }
        return !Objects.equals(this.getUserProfile().getWorkingLocation(), this.oldUserProfile.getWorkingLocation());
    }
}

