package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;

/**
 * It represents the payload for publication field of a search document.
 */
@Builder
@Schema(
    title = "DTO for Publication field of search document",
    description = "Represents the payload for publication field to create/update a search document"
)
@Data
public class CatalogPublicationDto {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateTimeFormats.ISO_DATE)
    @Schema(
        description = "Publication Date",
        example = "2025-03-31")
    private LocalDate date;

    @Schema(
            description = "Zip Code",
            example = "12345")
    private String zipCode;

    @Schema(
            description = "City",
            example = "Palermo")
    private String city;

    @Schema(
            description = "Region",
            example = "Sicily")
    private String region;

    @Schema(
            description = "Country",
            example = "Italy")
    private String country;

}
