package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the response for tags field for a Catalog search document.
 */
@Builder
@Schema(
    title = "Catalog search document tag response DTO",
    description = "Represents the response for tags field for Catalog search document"
)
@Data
public class OutputCatalogTagDto {

    @Schema(
        description = "Vocabulary ID",
        example = "")
    private String vocabularyId;

    @Schema(
        description = "Status",
        example = "active")
    private String state;

    @Schema(
        description = "Display Name",
        example = "ITSERR")
    private String displayName;

    @Schema(
        description = "ID",
        example = "dc7e376a-059b-49be-90a0-e7fbdbcdc0ba")
    private String id;

    @Schema(
        description = "Name",
        example = "ITSERR")
    private String name;

}
