package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;

/**
 * It represents the response for a User Profile search document.
 */
@Builder
@Schema(
    title = "User Profile search document response DTO",
    description = "Represents the response for User Profile search document"
)
@Data
public class OutputUserProfileDto {

    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "First Name",
        example = "John")
    private String firstName;

    @Schema(
        description = "Last Name",
        example = "Doe")
    private String lastName;

    @Schema(
        description = "Email address of the user",
        example = "john.doe@example.com")
    private String email;

    @Schema(
        description = "Folder Id of the User Profile",
        example = "550e8400-e29b-41d4-a716-446655440000")
    private String userProfileFolderId;

    @Schema(
        description = "Link of the image of user",
        example = "https://imageLink")
    private String imageUrl;

    @Schema(
        description = "Flag to indicate if user exists",
        example = "true")
    private Boolean userExists;

    @Schema(
        description = "Projects")
    private List<UserProfileProjectDto> projects;

    @Schema(
        description = "CV details of the user")
    private UserProfileCvDto cv;

    @Schema(
        description = "ORCID identifier of the user",
        example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(
        description = "Whether the user is open to collaboration",
        example = "false")
    private Boolean openToCollaboration;

    @Schema(description = "Whether the user's email is publicly visible", example = "true")
    private boolean showPublicEmail;

    @Schema(
        description = "Personal website URL",
        example = "https://johndoe.example.com")
    private String personalWebsite;

    @Schema(
        description = "LinkedIn profile URL",
        example = "https://linkedin.com/in/johndoe")
    private String linkedinProfile;

    @Schema(
        description = "Social profile URL (e.g., GitHub)",
        example = "https://github.com/johndoe")
    private String socialProfile;

    @Schema(
        description = "Short biography of the user",
        example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

    @Schema(description = "User's working location details")
    private LocationDto workingLocation;

    @Schema(
        description = "Organization affiliation",
        example = "Stanford University")
    private String organizationAffiliation;

    @Schema(
        description = "Scientific Disciplinary Sectors",
        example = "[\"INF/01\", \"ING-INF/05\"]")
    private List<String> ssd;

    @Schema(
            description = "Areas of Expertise")
    private List<ExpertiseDto> expertises;

    @Schema(description = "References")
    private ReferencesDto references;

    @Schema(description = "User preferred language")
    private String language;

    @Schema(description = "Whether the user profile is private or public", example = "false")
    private boolean publicProfile;

    @Schema(description = " thematic interests of user", example = "[\"Physics\", \"Maths\"]")
    private List<String> interests;

    @Schema(
        description = "The creation time of the table record",
        example = "2025-04-06T10:15:30Z")
    private Instant creationTime;

    @Schema(
        description = "The last update time of the table record",
        example = "2025-04-06T10:15:30Z")
    private Instant updateTime;
}
