/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageButtonDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageCopyrightDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageParagraphDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPagePublicationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageRepositoriesDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageSupportedOsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.RelatedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.UserProfileMinimalDto;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;

@Schema(title="Create/Update Institutional Page search document DTO", description="Represents the payload to create/update a Institutional Page search document")
public class InputInstitutionalPageDto
implements PutIdParameterBody {
    @Schema(description="ID of the institutional page", example="11111111-aaaa-0000-0000-000000000000")
    @NotBlank
    private String id;
    @Schema(description="The name of the institutional page", example="Criterion")
    private String name;
    @Schema(description="ID of the workspace folder related to the institutional page", example="22222222-aaaa-0000-0000-000000000000")
    private String workspaceFolderId;
    @Schema(description="The parent node of the institutional page")
    private RelatedInstitutionalPageDto parentInstitutionalPage;
    @Schema(description="The child nodes of the institutional page")
    private List<RelatedInstitutionalPageDto> childInstitutionalPages;
    @Schema(description="ID of the root institutional page")
    private String rootInstitutionalPageId;
    @Schema(description="Publication Time", example="2025-05-26T14:19:46.606883Z")
    private Instant publicationTime;
    @Schema(description="Indicates whether the institutional page is published", example="true")
    private Boolean published;
    @Schema(description="Rejection message of moderation", example="Not correct")
    private String rejectionMessage;
    @Schema(description="The category of the institutional page", allowableValues={"tool", "project"}, example="project")
    private String category;
    @Schema(description="The moderation status of the institutional page", allowableValues={"Pending", "Approved", "Rejected"}, example="Pending")
    private String moderationStatus;
    @Schema(description="The abstract of the institutional page", example="WP3, the Toolkit for Religious Studies (T-ReS), aims to improve the research experience.")
    private String abstractContent;
    @Schema(description="Copyright info for the institutional page")
    private InstitutionalPageCopyrightDto copyright;
    @Schema(description="Profile of the WP leads of the institutional page")
    private List<UserProfileMinimalDto> wpLeads;
    @Schema(description="Profile of members of the institutional page")
    private List<UserProfileMinimalDto> members;
    @Schema(description="Profile of the maintainer of the institutional page")
    private UserProfileMinimalDto maintainer;
    @Schema(description="Profile of the user who last modified the institutional page")
    private UserProfileMinimalDto lastModifiedBy;
    @Schema(description="The paragraphs related to the institutional page")
    private List<InstitutionalPageParagraphDto> paragraphs;
    @Schema(description="List of tags", example="[\"aramaic\",\"english\",\"italian\"]")
    private List<String> tags;
    @Schema(description="The image URL", example="https://picsum.photos/200")
    private String imageUrl;
    @Schema(description="The user manual URL", example="https://www.usermanual.com")
    private String userManualUrl;
    @Schema(description="The FAQs page URL", example="https://www.faqs.com")
    private String faqsUrl;
    @Schema(description="The application version", example="v1.3.0")
    private String applicationVersion;
    @Schema(description="The application type", example="web application")
    private String applicationType;
    @Schema(description="The license name", example="MIT License")
    private String license;
    @Schema(description="The supported operating systems for the institutional page")
    private InstitutionalPageSupportedOsDto supportedOs;
    @Schema(description="Output DTO of repository links for the institutional page")
    private InstitutionalPageRepositoriesDto repositories;
    @Schema(description="Additional arbitrary fields in key-value format", example="{\"developer\": \"John Doe\", \"releaseNotes\": \"Initial beta release\"}")
    private LinkedHashMap<String, String> additionalFields;
    @Schema(description="Buttons related to the institutional page")
    private List<InstitutionalPageButtonDto> buttons;
    @Schema(description="The publications associated to the institutional page")
    private List<InstitutionalPagePublicationDto> publications;
    @Schema(description="External links")
    private LinkedHashMap<String, String> externalLinks;
    @Schema(description="Created At", example="2025-05-26T14:19:46.606883Z")
    private Instant creationTime;
    @Schema(description="Last Updated At", example="2025-05-27T14:19:46.606883Z")
    private Instant updateTime;
    @Schema(description="Indicates whether the institutional page is waiting to be deleted", example="true")
    private Boolean toDelete;
    @Schema(description="Indicates whether the institutional page has an updated version", example="true")
    private Boolean hasUpdatedVersion;

    @Schema(hidden=true)
    @JsonIgnore
    @Hidden
    public String getPutId() {
        return this.id;
    }

    @Generated
    InputInstitutionalPageDto(String id, String name, String workspaceFolderId, RelatedInstitutionalPageDto parentInstitutionalPage, List<RelatedInstitutionalPageDto> childInstitutionalPages, String rootInstitutionalPageId, Instant publicationTime, Boolean published, String rejectionMessage, String category, String moderationStatus, String abstractContent, InstitutionalPageCopyrightDto copyright, List<UserProfileMinimalDto> wpLeads, List<UserProfileMinimalDto> members, UserProfileMinimalDto maintainer, UserProfileMinimalDto lastModifiedBy, List<InstitutionalPageParagraphDto> paragraphs, List<String> tags, String imageUrl, String userManualUrl, String faqsUrl, String applicationVersion, String applicationType, String license, InstitutionalPageSupportedOsDto supportedOs, InstitutionalPageRepositoriesDto repositories, LinkedHashMap<String, String> additionalFields, List<InstitutionalPageButtonDto> buttons, List<InstitutionalPagePublicationDto> publications, LinkedHashMap<String, String> externalLinks, Instant creationTime, Instant updateTime, Boolean toDelete, Boolean hasUpdatedVersion) {
        this.id = id;
        this.name = name;
        this.workspaceFolderId = workspaceFolderId;
        this.parentInstitutionalPage = parentInstitutionalPage;
        this.childInstitutionalPages = childInstitutionalPages;
        this.rootInstitutionalPageId = rootInstitutionalPageId;
        this.publicationTime = publicationTime;
        this.published = published;
        this.rejectionMessage = rejectionMessage;
        this.category = category;
        this.moderationStatus = moderationStatus;
        this.abstractContent = abstractContent;
        this.copyright = copyright;
        this.wpLeads = wpLeads;
        this.members = members;
        this.maintainer = maintainer;
        this.lastModifiedBy = lastModifiedBy;
        this.paragraphs = paragraphs;
        this.tags = tags;
        this.imageUrl = imageUrl;
        this.userManualUrl = userManualUrl;
        this.faqsUrl = faqsUrl;
        this.applicationVersion = applicationVersion;
        this.applicationType = applicationType;
        this.license = license;
        this.supportedOs = supportedOs;
        this.repositories = repositories;
        this.additionalFields = additionalFields;
        this.buttons = buttons;
        this.publications = publications;
        this.externalLinks = externalLinks;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.toDelete = toDelete;
        this.hasUpdatedVersion = hasUpdatedVersion;
    }

    @Generated
    public static InputInstitutionalPageDtoBuilder builder() {
        return new InputInstitutionalPageDtoBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getWorkspaceFolderId() {
        return this.workspaceFolderId;
    }

    @Generated
    public RelatedInstitutionalPageDto getParentInstitutionalPage() {
        return this.parentInstitutionalPage;
    }

    @Generated
    public List<RelatedInstitutionalPageDto> getChildInstitutionalPages() {
        return this.childInstitutionalPages;
    }

    @Generated
    public String getRootInstitutionalPageId() {
        return this.rootInstitutionalPageId;
    }

    @Generated
    public Instant getPublicationTime() {
        return this.publicationTime;
    }

    @Generated
    public Boolean getPublished() {
        return this.published;
    }

    @Generated
    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getModerationStatus() {
        return this.moderationStatus;
    }

    @Generated
    public String getAbstractContent() {
        return this.abstractContent;
    }

    @Generated
    public InstitutionalPageCopyrightDto getCopyright() {
        return this.copyright;
    }

    @Generated
    public List<UserProfileMinimalDto> getWpLeads() {
        return this.wpLeads;
    }

    @Generated
    public List<UserProfileMinimalDto> getMembers() {
        return this.members;
    }

    @Generated
    public UserProfileMinimalDto getMaintainer() {
        return this.maintainer;
    }

    @Generated
    public UserProfileMinimalDto getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Generated
    public List<InstitutionalPageParagraphDto> getParagraphs() {
        return this.paragraphs;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getUserManualUrl() {
        return this.userManualUrl;
    }

    @Generated
    public String getFaqsUrl() {
        return this.faqsUrl;
    }

    @Generated
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Generated
    public String getApplicationType() {
        return this.applicationType;
    }

    @Generated
    public String getLicense() {
        return this.license;
    }

    @Generated
    public InstitutionalPageSupportedOsDto getSupportedOs() {
        return this.supportedOs;
    }

    @Generated
    public InstitutionalPageRepositoriesDto getRepositories() {
        return this.repositories;
    }

    @Generated
    public LinkedHashMap<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Generated
    public List<InstitutionalPageButtonDto> getButtons() {
        return this.buttons;
    }

    @Generated
    public List<InstitutionalPagePublicationDto> getPublications() {
        return this.publications;
    }

    @Generated
    public LinkedHashMap<String, String> getExternalLinks() {
        return this.externalLinks;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Boolean getToDelete() {
        return this.toDelete;
    }

    @Generated
    public Boolean getHasUpdatedVersion() {
        return this.hasUpdatedVersion;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setWorkspaceFolderId(String workspaceFolderId) {
        this.workspaceFolderId = workspaceFolderId;
    }

    @Generated
    public void setParentInstitutionalPage(RelatedInstitutionalPageDto parentInstitutionalPage) {
        this.parentInstitutionalPage = parentInstitutionalPage;
    }

    @Generated
    public void setChildInstitutionalPages(List<RelatedInstitutionalPageDto> childInstitutionalPages) {
        this.childInstitutionalPages = childInstitutionalPages;
    }

    @Generated
    public void setRootInstitutionalPageId(String rootInstitutionalPageId) {
        this.rootInstitutionalPageId = rootInstitutionalPageId;
    }

    @Generated
    public void setPublicationTime(Instant publicationTime) {
        this.publicationTime = publicationTime;
    }

    @Generated
    public void setPublished(Boolean published) {
        this.published = published;
    }

    @Generated
    public void setRejectionMessage(String rejectionMessage) {
        this.rejectionMessage = rejectionMessage;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setModerationStatus(String moderationStatus) {
        this.moderationStatus = moderationStatus;
    }

    @Generated
    public void setAbstractContent(String abstractContent) {
        this.abstractContent = abstractContent;
    }

    @Generated
    public void setCopyright(InstitutionalPageCopyrightDto copyright) {
        this.copyright = copyright;
    }

    @Generated
    public void setWpLeads(List<UserProfileMinimalDto> wpLeads) {
        this.wpLeads = wpLeads;
    }

    @Generated
    public void setMembers(List<UserProfileMinimalDto> members) {
        this.members = members;
    }

    @Generated
    public void setMaintainer(UserProfileMinimalDto maintainer) {
        this.maintainer = maintainer;
    }

    @Generated
    public void setLastModifiedBy(UserProfileMinimalDto lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @Generated
    public void setParagraphs(List<InstitutionalPageParagraphDto> paragraphs) {
        this.paragraphs = paragraphs;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setUserManualUrl(String userManualUrl) {
        this.userManualUrl = userManualUrl;
    }

    @Generated
    public void setFaqsUrl(String faqsUrl) {
        this.faqsUrl = faqsUrl;
    }

    @Generated
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Generated
    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @Generated
    public void setSupportedOs(InstitutionalPageSupportedOsDto supportedOs) {
        this.supportedOs = supportedOs;
    }

    @Generated
    public void setRepositories(InstitutionalPageRepositoriesDto repositories) {
        this.repositories = repositories;
    }

    @Generated
    public void setAdditionalFields(LinkedHashMap<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    @Generated
    public void setButtons(List<InstitutionalPageButtonDto> buttons) {
        this.buttons = buttons;
    }

    @Generated
    public void setPublications(List<InstitutionalPagePublicationDto> publications) {
        this.publications = publications;
    }

    @Generated
    public void setExternalLinks(LinkedHashMap<String, String> externalLinks) {
        this.externalLinks = externalLinks;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setToDelete(Boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Generated
    public void setHasUpdatedVersion(Boolean hasUpdatedVersion) {
        this.hasUpdatedVersion = hasUpdatedVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputInstitutionalPageDto)) {
            return false;
        }
        InputInstitutionalPageDto other = (InputInstitutionalPageDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$published = this.getPublished();
        Boolean other$published = other.getPublished();
        if (this$published == null ? other$published != null : !((Object)this$published).equals(other$published)) {
            return false;
        }
        Boolean this$toDelete = this.getToDelete();
        Boolean other$toDelete = other.getToDelete();
        if (this$toDelete == null ? other$toDelete != null : !((Object)this$toDelete).equals(other$toDelete)) {
            return false;
        }
        Boolean this$hasUpdatedVersion = this.getHasUpdatedVersion();
        Boolean other$hasUpdatedVersion = other.getHasUpdatedVersion();
        if (this$hasUpdatedVersion == null ? other$hasUpdatedVersion != null : !((Object)this$hasUpdatedVersion).equals(other$hasUpdatedVersion)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$workspaceFolderId = this.getWorkspaceFolderId();
        String other$workspaceFolderId = other.getWorkspaceFolderId();
        if (this$workspaceFolderId == null ? other$workspaceFolderId != null : !this$workspaceFolderId.equals(other$workspaceFolderId)) {
            return false;
        }
        RelatedInstitutionalPageDto this$parentInstitutionalPage = this.getParentInstitutionalPage();
        RelatedInstitutionalPageDto other$parentInstitutionalPage = other.getParentInstitutionalPage();
        if (this$parentInstitutionalPage == null ? other$parentInstitutionalPage != null : !this$parentInstitutionalPage.equals(other$parentInstitutionalPage)) {
            return false;
        }
        List this$childInstitutionalPages = this.getChildInstitutionalPages();
        List other$childInstitutionalPages = other.getChildInstitutionalPages();
        if (this$childInstitutionalPages == null ? other$childInstitutionalPages != null : !((Object)this$childInstitutionalPages).equals(other$childInstitutionalPages)) {
            return false;
        }
        String this$rootInstitutionalPageId = this.getRootInstitutionalPageId();
        String other$rootInstitutionalPageId = other.getRootInstitutionalPageId();
        if (this$rootInstitutionalPageId == null ? other$rootInstitutionalPageId != null : !this$rootInstitutionalPageId.equals(other$rootInstitutionalPageId)) {
            return false;
        }
        Instant this$publicationTime = this.getPublicationTime();
        Instant other$publicationTime = other.getPublicationTime();
        if (this$publicationTime == null ? other$publicationTime != null : !((Object)this$publicationTime).equals(other$publicationTime)) {
            return false;
        }
        String this$rejectionMessage = this.getRejectionMessage();
        String other$rejectionMessage = other.getRejectionMessage();
        if (this$rejectionMessage == null ? other$rejectionMessage != null : !this$rejectionMessage.equals(other$rejectionMessage)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$moderationStatus = this.getModerationStatus();
        String other$moderationStatus = other.getModerationStatus();
        if (this$moderationStatus == null ? other$moderationStatus != null : !this$moderationStatus.equals(other$moderationStatus)) {
            return false;
        }
        String this$abstractContent = this.getAbstractContent();
        String other$abstractContent = other.getAbstractContent();
        if (this$abstractContent == null ? other$abstractContent != null : !this$abstractContent.equals(other$abstractContent)) {
            return false;
        }
        InstitutionalPageCopyrightDto this$copyright = this.getCopyright();
        InstitutionalPageCopyrightDto other$copyright = other.getCopyright();
        if (this$copyright == null ? other$copyright != null : !this$copyright.equals(other$copyright)) {
            return false;
        }
        List this$wpLeads = this.getWpLeads();
        List other$wpLeads = other.getWpLeads();
        if (this$wpLeads == null ? other$wpLeads != null : !((Object)this$wpLeads).equals(other$wpLeads)) {
            return false;
        }
        List this$members = this.getMembers();
        List other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        UserProfileMinimalDto this$maintainer = this.getMaintainer();
        UserProfileMinimalDto other$maintainer = other.getMaintainer();
        if (this$maintainer == null ? other$maintainer != null : !this$maintainer.equals(other$maintainer)) {
            return false;
        }
        UserProfileMinimalDto this$lastModifiedBy = this.getLastModifiedBy();
        UserProfileMinimalDto other$lastModifiedBy = other.getLastModifiedBy();
        if (this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy)) {
            return false;
        }
        List this$paragraphs = this.getParagraphs();
        List other$paragraphs = other.getParagraphs();
        if (this$paragraphs == null ? other$paragraphs != null : !((Object)this$paragraphs).equals(other$paragraphs)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$userManualUrl = this.getUserManualUrl();
        String other$userManualUrl = other.getUserManualUrl();
        if (this$userManualUrl == null ? other$userManualUrl != null : !this$userManualUrl.equals(other$userManualUrl)) {
            return false;
        }
        String this$faqsUrl = this.getFaqsUrl();
        String other$faqsUrl = other.getFaqsUrl();
        if (this$faqsUrl == null ? other$faqsUrl != null : !this$faqsUrl.equals(other$faqsUrl)) {
            return false;
        }
        String this$applicationVersion = this.getApplicationVersion();
        String other$applicationVersion = other.getApplicationVersion();
        if (this$applicationVersion == null ? other$applicationVersion != null : !this$applicationVersion.equals(other$applicationVersion)) {
            return false;
        }
        String this$applicationType = this.getApplicationType();
        String other$applicationType = other.getApplicationType();
        if (this$applicationType == null ? other$applicationType != null : !this$applicationType.equals(other$applicationType)) {
            return false;
        }
        String this$license = this.getLicense();
        String other$license = other.getLicense();
        if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
            return false;
        }
        InstitutionalPageSupportedOsDto this$supportedOs = this.getSupportedOs();
        InstitutionalPageSupportedOsDto other$supportedOs = other.getSupportedOs();
        if (this$supportedOs == null ? other$supportedOs != null : !this$supportedOs.equals(other$supportedOs)) {
            return false;
        }
        InstitutionalPageRepositoriesDto this$repositories = this.getRepositories();
        InstitutionalPageRepositoriesDto other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories)) {
            return false;
        }
        LinkedHashMap this$additionalFields = this.getAdditionalFields();
        LinkedHashMap other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        List this$buttons = this.getButtons();
        List other$buttons = other.getButtons();
        if (this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons)) {
            return false;
        }
        List this$publications = this.getPublications();
        List other$publications = other.getPublications();
        if (this$publications == null ? other$publications != null : !((Object)this$publications).equals(other$publications)) {
            return false;
        }
        LinkedHashMap this$externalLinks = this.getExternalLinks();
        LinkedHashMap other$externalLinks = other.getExternalLinks();
        if (this$externalLinks == null ? other$externalLinks != null : !((Object)this$externalLinks).equals(other$externalLinks)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputInstitutionalPageDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $published = this.getPublished();
        result = result * 59 + ($published == null ? 43 : ((Object)$published).hashCode());
        Boolean $toDelete = this.getToDelete();
        result = result * 59 + ($toDelete == null ? 43 : ((Object)$toDelete).hashCode());
        Boolean $hasUpdatedVersion = this.getHasUpdatedVersion();
        result = result * 59 + ($hasUpdatedVersion == null ? 43 : ((Object)$hasUpdatedVersion).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $workspaceFolderId = this.getWorkspaceFolderId();
        result = result * 59 + ($workspaceFolderId == null ? 43 : $workspaceFolderId.hashCode());
        RelatedInstitutionalPageDto $parentInstitutionalPage = this.getParentInstitutionalPage();
        result = result * 59 + ($parentInstitutionalPage == null ? 43 : $parentInstitutionalPage.hashCode());
        List $childInstitutionalPages = this.getChildInstitutionalPages();
        result = result * 59 + ($childInstitutionalPages == null ? 43 : ((Object)$childInstitutionalPages).hashCode());
        String $rootInstitutionalPageId = this.getRootInstitutionalPageId();
        result = result * 59 + ($rootInstitutionalPageId == null ? 43 : $rootInstitutionalPageId.hashCode());
        Instant $publicationTime = this.getPublicationTime();
        result = result * 59 + ($publicationTime == null ? 43 : ((Object)$publicationTime).hashCode());
        String $rejectionMessage = this.getRejectionMessage();
        result = result * 59 + ($rejectionMessage == null ? 43 : $rejectionMessage.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $moderationStatus = this.getModerationStatus();
        result = result * 59 + ($moderationStatus == null ? 43 : $moderationStatus.hashCode());
        String $abstractContent = this.getAbstractContent();
        result = result * 59 + ($abstractContent == null ? 43 : $abstractContent.hashCode());
        InstitutionalPageCopyrightDto $copyright = this.getCopyright();
        result = result * 59 + ($copyright == null ? 43 : $copyright.hashCode());
        List $wpLeads = this.getWpLeads();
        result = result * 59 + ($wpLeads == null ? 43 : ((Object)$wpLeads).hashCode());
        List $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        UserProfileMinimalDto $maintainer = this.getMaintainer();
        result = result * 59 + ($maintainer == null ? 43 : $maintainer.hashCode());
        UserProfileMinimalDto $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        List $paragraphs = this.getParagraphs();
        result = result * 59 + ($paragraphs == null ? 43 : ((Object)$paragraphs).hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $userManualUrl = this.getUserManualUrl();
        result = result * 59 + ($userManualUrl == null ? 43 : $userManualUrl.hashCode());
        String $faqsUrl = this.getFaqsUrl();
        result = result * 59 + ($faqsUrl == null ? 43 : $faqsUrl.hashCode());
        String $applicationVersion = this.getApplicationVersion();
        result = result * 59 + ($applicationVersion == null ? 43 : $applicationVersion.hashCode());
        String $applicationType = this.getApplicationType();
        result = result * 59 + ($applicationType == null ? 43 : $applicationType.hashCode());
        String $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : $license.hashCode());
        InstitutionalPageSupportedOsDto $supportedOs = this.getSupportedOs();
        result = result * 59 + ($supportedOs == null ? 43 : $supportedOs.hashCode());
        InstitutionalPageRepositoriesDto $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
        LinkedHashMap $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        List $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        List $publications = this.getPublications();
        result = result * 59 + ($publications == null ? 43 : ((Object)$publications).hashCode());
        LinkedHashMap $externalLinks = this.getExternalLinks();
        result = result * 59 + ($externalLinks == null ? 43 : ((Object)$externalLinks).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputInstitutionalPageDto(id=" + this.getId() + ", name=" + this.getName() + ", workspaceFolderId=" + this.getWorkspaceFolderId() + ", parentInstitutionalPage=" + String.valueOf(this.getParentInstitutionalPage()) + ", childInstitutionalPages=" + String.valueOf(this.getChildInstitutionalPages()) + ", rootInstitutionalPageId=" + this.getRootInstitutionalPageId() + ", publicationTime=" + String.valueOf(this.getPublicationTime()) + ", published=" + this.getPublished() + ", rejectionMessage=" + this.getRejectionMessage() + ", category=" + this.getCategory() + ", moderationStatus=" + this.getModerationStatus() + ", abstractContent=" + this.getAbstractContent() + ", copyright=" + String.valueOf(this.getCopyright()) + ", wpLeads=" + String.valueOf(this.getWpLeads()) + ", members=" + String.valueOf(this.getMembers()) + ", maintainer=" + String.valueOf(this.getMaintainer()) + ", lastModifiedBy=" + String.valueOf(this.getLastModifiedBy()) + ", paragraphs=" + String.valueOf(this.getParagraphs()) + ", tags=" + String.valueOf(this.getTags()) + ", imageUrl=" + this.getImageUrl() + ", userManualUrl=" + this.getUserManualUrl() + ", faqsUrl=" + this.getFaqsUrl() + ", applicationVersion=" + this.getApplicationVersion() + ", applicationType=" + this.getApplicationType() + ", license=" + this.getLicense() + ", supportedOs=" + String.valueOf(this.getSupportedOs()) + ", repositories=" + String.valueOf(this.getRepositories()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ", buttons=" + String.valueOf(this.getButtons()) + ", publications=" + String.valueOf(this.getPublications()) + ", externalLinks=" + String.valueOf(this.getExternalLinks()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", toDelete=" + this.getToDelete() + ", hasUpdatedVersion=" + this.getHasUpdatedVersion() + ")";
    }
}

