/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputInstitutionalPageLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.InstitutionalPage;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.MapperConfiguration;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.UserProfileMapper;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;

@Mapper(config=MapperConfiguration.class, uses={UserProfileMapper.class})
public interface InstitutionalPageMapper {
    public static final String NAMED_TO_ALLOWED_USER_IDS = "toAllowedUserIds";

    @Mappings(value={@Mapping(target="score", ignore=true), @Mapping(target="allowedUserIds", source="dto", qualifiedByName={"toAllowedUserIds"})})
    public InstitutionalPage toEntity(InputInstitutionalPageDto var1);

    public OutputInstitutionalPageDto toDto(InstitutionalPage var1);

    @Mapping(target="title", source="name")
    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(InstitutionalPage var1);

    public OutputInstitutionalPageLocalSearchDto toLocalSearchDto(InstitutionalPage var1);

    @Mappings(value={@Mapping(target="title", source="name"), @Mapping(target="description", source="abstractContent")})
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(InstitutionalPage var1);

    @Named(value="toAllowedUserIds")
    default public Set<String> toAllowedUserIds(InputInstitutionalPageDto dto) {
        if (Boolean.TRUE.equals(dto.getPublished())) {
            return Set.of("all");
        }
        LinkedHashSet<String> allowedUserIds = new LinkedHashSet<String>();
        Optional.ofNullable(dto.getMembers()).orElse(List.of()).forEach(user -> allowedUserIds.add(user.getId()));
        Optional.ofNullable(dto.getWpLeads()).orElse(List.of()).forEach(user -> allowedUserIds.add(user.getId()));
        return allowedUserIds;
    }
}

