/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.DefaultSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.InstitutionalPageSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputInstitutionalPageLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.InstitutionalPage;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfileMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.event.UserProfileUpdatedEvent;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.InstitutionalPageRepository;
import com.finconsgroup.itserr.marketplace.search.dm.service.InstitutionalPageService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultInstitutionalPageService
implements InstitutionalPageService,
ApplicationListener<UserProfileUpdatedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultInstitutionalPageService.class);
    private final InstitutionalPageRepository institutionalPageRepository;
    private final InstitutionalPageMapper institutionalPageMapper;
    private final InstitutionalPageSearchProperties institutionalPageSearchProperties;
    private final Map<String, String> sortFilterPropertyMap;

    public DefaultInstitutionalPageService(InstitutionalPageRepository institutionalPageRepository, InstitutionalPageMapper institutionalPageMapper, InstitutionalPageSearchProperties institutionalPageSearchProperties, DefaultSearchProperties defaultSearchProperties) {
        this.institutionalPageRepository = institutionalPageRepository;
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageSearchProperties = institutionalPageSearchProperties;
        this.sortFilterPropertyMap = this.buildSortFilterPropertyMap(institutionalPageSearchProperties.search(), defaultSearchProperties.search().sortFilterPropertyMap());
    }

    @Transactional
    @NonNull
    public OutputInstitutionalPageDto upsertDocument(@NonNull InputInstitutionalPageDto dto) {
        InstitutionalPage institutionalPage = this.institutionalPageMapper.toEntity(dto);
        InstitutionalPage savedInstitutionalPage = (InstitutionalPage)this.institutionalPageRepository.save((Object)institutionalPage);
        return this.institutionalPageMapper.toDto(savedInstitutionalPage);
    }

    @Transactional(readOnly=true)
    @NonNull
    public OutputInstitutionalPageDto getDocument(@NonNull String id) {
        InstitutionalPage savedInstitutionalPage = (InstitutionalPage)this.institutionalPageRepository.findById((Object)id).orElseThrow(() -> new WP2ResourceNotFoundException("search_dm_institutionalPage_not_found"));
        return this.institutionalPageMapper.toDto(savedInstitutionalPage);
    }

    @Transactional
    public void deleteDocument(@NonNull String id) {
        if (!this.institutionalPageRepository.existsById((Object)id)) {
            throw new WP2ResourceNotFoundException("search_dm_institutionalPage_not_found");
        }
        this.institutionalPageRepository.deleteById((Object)id);
    }

    public void deleteAll() {
        if (!this.institutionalPageSearchProperties.search().enableDeleteAll()) {
            throw new WP2BusinessException("search_dm_institutionalPage_delete_all_not_enabled");
        }
        this.institutionalPageRepository.deleteAll();
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(List.of())).build(), this.institutionalPageSearchProperties.search().autoCompletion().sourceFields(), arg_0 -> ((InstitutionalPageMapper)this.institutionalPageMapper).toAutoCompleteDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.institutionalPageSearchProperties.search().autoCompletion().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchAutoCompleteDto.builder().category(Category.INSTITUTIONAL_PAGE.getId()).data(resultPage.getContent()).build());
    }

    @NonNull
    @Transactional(readOnly=true)
    public Page<OutputInstitutionalPageLocalSearchDto> getLocalSearch(String terms, String filters, @NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap))).build();
        Pageable sortedPageable = this.applySort(pageable, this.institutionalPageSearchProperties.search(), this.sortFilterPropertyMap);
        return this.search(searchRequest, this.institutionalPageSearchProperties.search().local().sourceFields(), arg_0 -> ((InstitutionalPageMapper)this.institutionalPageMapper).toLocalSearchDto(arg_0), sortedPageable);
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        Map searchResultAggregatedByType = this.searchByAggregation(SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(List.of())).build(), this.institutionalPageSearchProperties.search().globalSearch().sourceFields(), this.institutionalPageSearchProperties.search().globalSearch().topHitsLimit().intValue(), this.institutionalPageSearchProperties.search().globalSearch().aggregation(), arg_0 -> ((InstitutionalPageMapper)this.institutionalPageMapper).toGlobalSearchDataDto(arg_0));
        if (searchResultAggregatedByType.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputGlobalSearchDto> globalSearchResults = new ArrayList<OutputGlobalSearchDto>();
        searchResultAggregatedByType.forEach((type, results) -> globalSearchResults.add(OutputGlobalSearchDto.builder().category(Category.INSTITUTIONAL_PAGE.getId()).type(type).data(results).build()));
        return globalSearchResults;
    }

    public void onApplicationEvent(@NonNull UserProfileUpdatedEvent event) {
        try {
            if (event.isUserProfileMinimalUpdated()) {
                this.syncDocumentsForUserProfile(event.getUserProfile());
            }
        }
        catch (Exception ex) {
            log.error("Error occurred while syncing institutional pages for user profile with id - {}", (Object)event.getUserProfile().getId(), (Object)ex);
        }
    }

    @NonNull
    public Page<InstitutionalPage> searchDocumentsForUserProfileSync(@NonNull SearchRequest searchRequest, @NonNull Pageable pageable) {
        return this.search(searchRequest, null, Function.identity(), pageable);
    }

    public void syncDocumentForUserProfile(@NonNull InstitutionalPage institutionalPage, @NonNull UserProfile userProfile) {
        boolean updated = false;
        if (institutionalPage.getMembers() != null) {
            for (UserProfileMinimal contributor : institutionalPage.getMembers()) {
                if (!this.checkAndUpdateUserProfileMinimal(contributor, userProfile)) continue;
                updated = true;
            }
        }
        if (institutionalPage.getMaintainer() != null && this.checkAndUpdateUserProfileMinimal(institutionalPage.getMaintainer(), userProfile)) {
            updated = true;
        }
        if (institutionalPage.getLastModifiedBy() != null && this.checkAndUpdateUserProfileMinimal(institutionalPage.getLastModifiedBy(), userProfile)) {
            updated = true;
        }
        if (institutionalPage.getWpLeads() != null) {
            for (UserProfileMinimal wpLead : institutionalPage.getWpLeads()) {
                if (!this.checkAndUpdateUserProfileMinimal(wpLead, userProfile)) continue;
                updated = true;
            }
        }
        if (updated) {
            this.institutionalPageRepository.save((Object)institutionalPage);
        }
    }

    @NonNull
    public Class<InstitutionalPage> getDocumentClass() {
        return InstitutionalPage.class;
    }

    @NonNull
    public SearchProperties getSearchProperties() {
        return this.institutionalPageSearchProperties.search();
    }

    @NonNull
    public CustomQueryRepository getCustomQueryRepository() {
        return this.institutionalPageRepository;
    }

    @NonNull
    public CustomAggregationRepository getCustomAggregationRepository() {
        return this.institutionalPageRepository;
    }

    private List<QueryFilter> addDefaultFilters(@NonNull List<QueryFilter> queryFilters) {
        ArrayList<QueryFilter> filtersWithDefaults = new ArrayList<QueryFilter>(queryFilters);
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add("all");
        JwtTokenHolder.getUserId().map(UUID::toString).ifPresent(userIds::add);
        filtersWithDefaults.add(QueryFilter.builder().fieldName("allowedUserIds").filterValues(userIds).build());
        return filtersWithDefaults;
    }

    private boolean checkAndUpdateUserProfileMinimal(UserProfileMinimal userProfileMinimal, UserProfile userProfile) {
        if (Objects.equals(userProfileMinimal.getId(), userProfile.getId()) && this.isUserProfileMinimalUpdated(userProfileMinimal, userProfile)) {
            this.updateUserProfileMinimal(userProfileMinimal, userProfile);
            return true;
        }
        return false;
    }
}

