/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.DefaultSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.NewsSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.News;
import com.finconsgroup.itserr.marketplace.search.dm.entity.RegisteredAuthor;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.event.UserProfileUpdatedEvent;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.NewsMapper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.NewsRepository;
import com.finconsgroup.itserr.marketplace.search.dm.service.NewsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultNewsService
implements NewsService,
ApplicationListener<UserProfileUpdatedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNewsService.class);
    private final NewsRepository newsRepository;
    private final NewsMapper newsMapper;
    private final NewsSearchProperties newsSearchProperties;
    private final Map<String, String> sortFilterPropertyMap;

    public DefaultNewsService(NewsRepository newsRepository, NewsMapper newsMapper, NewsSearchProperties newsSearchProperties, DefaultSearchProperties defaultSearchProperties) {
        this.newsRepository = newsRepository;
        this.newsMapper = newsMapper;
        this.newsSearchProperties = newsSearchProperties;
        this.sortFilterPropertyMap = this.buildSortFilterPropertyMap(newsSearchProperties.search(), defaultSearchProperties.search().sortFilterPropertyMap());
    }

    @Transactional
    @NonNull
    public OutputNewsDto upsertDocument(@NonNull InputNewsDto dto) {
        News news = this.newsMapper.toEntity(dto);
        News savedNews = (News)this.newsRepository.save((Object)news);
        return this.newsMapper.toDto(savedNews);
    }

    @Transactional(readOnly=true)
    @NonNull
    public OutputNewsDto getDocument(@NonNull String id) {
        News savedNews = (News)this.newsRepository.findById((Object)id).orElseThrow(() -> new WP2ResourceNotFoundException("search_dm_news_not_found"));
        return this.newsMapper.toDto(savedNews);
    }

    @Transactional
    public void deleteDocument(@NonNull String id) {
        if (!this.newsRepository.existsById((Object)id)) {
            throw new WP2ResourceNotFoundException("search_dm_news_not_found");
        }
        this.newsRepository.deleteById((Object)id);
    }

    public void deleteAll() {
        if (!this.newsSearchProperties.search().enableDeleteAll()) {
            throw new WP2BusinessException("search_dm_news_delete_all_not_enabled");
        }
        this.newsRepository.deleteAll();
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).build(), this.newsSearchProperties.search().autoCompletion().sourceFields(), arg_0 -> ((NewsMapper)this.newsMapper).toAutoCompleteDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.newsSearchProperties.search().autoCompletion().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchAutoCompleteDto.builder().category(Category.NEWS.getId()).data(resultPage.getContent()).build());
    }

    @NonNull
    @Transactional(readOnly=true)
    public Page<OutputNewsLocalSearchDto> getLocalSearch(String terms, String filters, @NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().terms(terms).queryFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap)).build();
        Pageable sortedPageable = this.applySort(pageable, this.newsSearchProperties.search(), this.sortFilterPropertyMap);
        return this.search(searchRequest, this.newsSearchProperties.search().local().sourceFields(), arg_0 -> ((NewsMapper)this.newsMapper).toLocalSearchDto(arg_0), sortedPageable);
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        Map searchResultAggregatedByType = this.searchByAggregation(SearchRequest.builder().terms(terms).build(), this.newsSearchProperties.search().globalSearch().sourceFields(), this.newsSearchProperties.search().globalSearch().topHitsLimit().intValue(), this.newsSearchProperties.search().globalSearch().aggregation(), arg_0 -> ((NewsMapper)this.newsMapper).toGlobalSearchDataDto(arg_0));
        if (searchResultAggregatedByType.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputGlobalSearchDto> globalSearchResults = new ArrayList<OutputGlobalSearchDto>();
        searchResultAggregatedByType.forEach((type, results) -> globalSearchResults.add(OutputGlobalSearchDto.builder().category(Category.NEWS.getId()).type(type).data(results).build()));
        return globalSearchResults;
    }

    public void onApplicationEvent(@NonNull UserProfileUpdatedEvent event) {
        try {
            if (event.isUserProfileMinimalUpdated() || event.isLocationUpdated()) {
                this.syncDocumentsForUserProfile(event.getUserProfile());
            }
        }
        catch (Exception ex) {
            log.error("Error occurred while syncing news for user profile with id - {}", (Object)event.getUserProfile().getId(), (Object)ex);
        }
    }

    @NonNull
    public Page<News> searchDocumentsForUserProfileSync(@NonNull SearchRequest searchRequest, @NonNull Pageable pageable) {
        return this.search(searchRequest, null, Function.identity(), pageable);
    }

    public void syncDocumentForUserProfile(@NonNull News news, @NonNull UserProfile userProfile) {
        boolean updated = false;
        if (news.getCreator() != null && Objects.equals(news.getCreator().getId(), userProfile.getId()) && this.isRegisteredAuthorUserProfileUpdated(news.getCreator(), userProfile)) {
            this.updateRegisteredAuthorUserProfile(news.getCreator(), userProfile);
            updated = true;
        }
        if (news.getAuthors() != null) {
            for (RegisteredAuthor registeredAuthor : news.getAuthors()) {
                if (!Objects.equals(registeredAuthor.getId(), userProfile.getId()) || !this.isRegisteredAuthorUserProfileUpdated(registeredAuthor, userProfile)) continue;
                this.updateRegisteredAuthorUserProfile(registeredAuthor, userProfile);
                updated = true;
            }
        }
        if (updated) {
            this.newsRepository.save((Object)news);
        }
    }

    @NonNull
    public Class<News> getDocumentClass() {
        return News.class;
    }

    @NonNull
    public SearchProperties getSearchProperties() {
        return this.newsSearchProperties.search();
    }

    @NonNull
    public CustomQueryRepository getCustomQueryRepository() {
        return this.newsRepository;
    }

    @NonNull
    public CustomAggregationRepository getCustomAggregationRepository() {
        return this.newsRepository;
    }
}

