package com.finconsgroup.itserr.marketplace.userprofile.bs;

import com.finconsgroup.itserr.marketplace.userprofile.bs.config.properties.UserProfileBsConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "UserProfile BS API",
        description = "API definition of the UserProfile Microservice",
        version = "1.0.0"
))
@EnableConfigurationProperties({
        UserProfileBsConfigurationProperties.class
})
public class UserProfileBsApplication {

    public static void main(String[] args) {
        SpringApplication.run(UserProfileBsApplication.class, args);
    }

}
