package com.finconsgroup.itserr.marketplace.userprofile.bs.client;

import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputUsernameListD4SDto;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * D4S social networking library related APIs client.
 * <a href="https://api.d4science.org/social-networking-library-ws/api-docs/index.html">
 *     Click here for more information on all APIs</a>
 */
public interface SocialNetworkingD4SClient {

    /**
     * Feign client method for retrieving the list of all usernames
     * belonging to a particular role in D4Science.
     *
     * @return An {@link OutputUsernameListD4SDto} containing the success flag, optional message, and the list of usernames.
     * @throws feign.FeignException.FeignClientException.Unauthorized if the user is not authenticated.
     * @throws feign.FeignException.FeignClientException.InternalServerError if the user has invalid credentials.
     */
    @GetMapping("/rest/2/users/get-usernames-by-role")
    OutputUsernameListD4SDto getUsernamesByRole(@RequestParam("role-name") String roleName);
}
