package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * DTO for finding user profile info for matching interests.
 */
@Schema(name = "FindUserProfilesByInterestsDto", description = "DTO for finding user profile ids for matching interests")
@Data
@Builder
@AllArgsConstructor
public class InputFindUserProfilesByInterestsDto {

    @NotEmpty
    @Schema(
            description = "The strings to check for matching interests",
            example = "[\"Java\", \"This is a new catalog item for a document related to Java Programming\"]")
    List<String> stringsToCheck;
}
