package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * DTO for patching user profile project info.
 */
@Schema(name = "InputPatchUserProfileProjectDto", description = "DTO for patching user profile project details")
@Data
@Builder
@AllArgsConstructor
public class InputPatchUserProfileProjectDto {

    @NotEmpty
    @Schema(
            description = "Ids of the user profiles to update",
            example = "[\"550e8400-e29b-41d4-a716-446655440000\", \"550e8400-e29b-41d4-a716-446655449999\"]")
    List<UUID> userIds;

    @NotEmpty
    @Schema(
            description = "Ids of the project to update",
            example = "[\"550e8400-e29b-41d4-a716-446655440000\", \"550e8400-e29b-41d4-a716-446655449999\"]")
    List<UUID> projectIdIds;

    @Schema(description = "leader of the work project", example = "false")
    private Boolean wpLead;
}
