package com.finconsgroup.itserr.marketplace.userprofile.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsement;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsementApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileEndorsementMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * The implementation for ApplicationListener to listen to User Profile Endorsement application events
 * and produce relevant messages.
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class MessagingUserProfileEndorsementApplicationEventListener implements ApplicationListener<UserProfileEndorsementApplicationEvent> {

    private final EventProducer eventProducer;
    private final UserProfileMapper userProfileMapper;

    @Override
    public void onApplicationEvent(@NonNull UserProfileEndorsementApplicationEvent event) {
        MessagingEventDto<UserProfileEndorsementMessagingAdditionalDataDto> messagingEventDto =
                userProfileMapper.toMessagingEventDto(event.getUserProfileEndorsement());

        MessagingEventUserDto user = MessagingEventUserDto.builder()
                .id(JwtTokenHolder.getUserId().orElse(null))
                .name(JwtTokenHolder.getName().orElse(null))
                .username(JwtTokenHolder.getPreferredUsername().orElse(null))
                .build();
        messagingEventDto.setUser(user);

        UserProfileEndorsement userProfileEndorsement = event.getUserProfileEndorsement();
        messagingEventDto.setTimestamp(userProfileEndorsement.getTimestamp());

        UserProfileEndorsementMessagingAdditionalDataDto additionalData = new UserProfileEndorsementMessagingAdditionalDataDto();
        additionalData.setNotifyUserIds(userProfileEndorsement.getNotifyUserIds());
        additionalData.setExpertiseId(userProfileEndorsement.getExpertiseId());
        additionalData.setExpertiseDisplayName(userProfileEndorsement.getExpertiseDisplayName());
        messagingEventDto.setAdditionalData(additionalData);

        eventProducer.publishEndorsementEvent(messagingEventDto);
    }

}
